/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.controller.impl;

import com.google.common.base.Objects;
import cool.taomu.box.job.server.controller.inter.ITaskController;
import cool.taomu.box.job.server.dao.TaskDao;
import cool.taomu.box.job.server.entity.TaskEntity;
import cool.taomu.box.job.server.utils.ShellExecute;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Path(value="job")
public class TaskController
implements ITaskController<TaskEntity> {
    @Inject
    private TaskDao dao;
    private File dir = new File(System.getProperty("user.dir") + "/script/");

    @Override
    public Response getTask(String uuid) {
        TaskEntity entity = this.dao.getOneTask(uuid);
        return Response.ok((Object)entity).build();
    }

    @Override
    public Response putTask(String uuid, TaskEntity entity) {
        TaskEntity e = this.dao.getOneTask(uuid);
        entity.setTaskId(e.getTaskId());
        this.dao.deleteOneTask(e.getTaskId());
        this.dao.saveTask(e);
        return Response.ok((Object)entity).build();
    }

    @Override
    public Response deleteTask(String uuid) {
        this.dao.deleteOneTask(uuid);
        return Response.ok().build();
    }

    @Override
    public Response postTask(TaskEntity entity) {
        try {
            boolean _greaterThan;
            int _saveTask = this.dao.saveTask(entity);
            boolean bl = _greaterThan = _saveTask > 0;
            if (_greaterThan) {
                boolean _not;
                boolean _exists = this.dir.exists();
                boolean bl2 = _not = !_exists;
                if (_not) {
                    this.dir.mkdirs();
                }
                int _shellType = entity.getShellType();
                boolean _matched = false;
                int _ordinal = TaskEntity.ShellType.Shell.ordinal();
                if (Objects.equal((Object)_shellType, (Object)_ordinal)) {
                    _matched = true;
                    String _absolutePath = this.dir.getAbsolutePath();
                    String _shellName = entity.getShellName();
                    String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath, "/", _shellName, ".sh"})), (CharSequence)"");
                    File _file = new File(_join);
                    FileUtils.writeStringToFile((File)_file, (String)entity.getShell(), (String)"UTF-8", (boolean)false);
                }
                if (!_matched) {
                    int _ordinal_1 = TaskEntity.ShellType.BatchFile.ordinal();
                    if (Objects.equal((Object)_shellType, (Object)_ordinal_1)) {
                        _matched = true;
                        String _absolutePath_1 = this.dir.getAbsolutePath();
                        String _shellName_1 = entity.getShellName();
                        String _join_1 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath_1, "/", _shellName_1, ".bat"})), (CharSequence)"");
                        File _file_1 = new File(_join_1);
                        FileUtils.writeStringToFile((File)_file_1, (String)entity.getShell(), (String)"UTF-8", (boolean)false);
                    }
                }
                if (!_matched) {
                    int _ordinal_2 = TaskEntity.ShellType.Groovy.ordinal();
                    if (Objects.equal((Object)_shellType, (Object)_ordinal_2)) {
                        _matched = true;
                        String _absolutePath_2 = this.dir.getAbsolutePath();
                        String _shellName_2 = entity.getShellName();
                        String _join_2 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath_2, "/", _shellName_2, ".groovy"})), (CharSequence)"");
                        File _file_2 = new File(_join_2);
                        FileUtils.writeStringToFile((File)_file_2, (String)entity.getShell(), (String)"UTF-8", (boolean)false);
                    }
                }
                if (!_matched) {
                    int _ordinal_3 = TaskEntity.ShellType.JavaScript.ordinal();
                    if (Objects.equal((Object)_shellType, (Object)_ordinal_3)) {
                        _matched = true;
                        String _absolutePath_3 = this.dir.getAbsolutePath();
                        String _shellName_3 = entity.getShellName();
                        String _join_3 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath_3, "/", _shellName_3, ".js"})), (CharSequence)"");
                        File _file_3 = new File(_join_3);
                        FileUtils.writeStringToFile((File)_file_3, (String)entity.getShell(), (String)"UTF-8", (boolean)false);
                    }
                }
                if (!_matched) {
                    return Response.status((int)500).build();
                }
                return Response.status((int)201).build();
            }
            return Response.status((int)304).build();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Response runTask(String uuid) {
        TaskEntity entity = this.dao.getOneTask(uuid);
        int _shellType = entity.getShellType();
        boolean _matched = false;
        int _ordinal = TaskEntity.ShellType.Shell.ordinal();
        if (Objects.equal((Object)_shellType, (Object)_ordinal)) {
            _matched = true;
            String _absolutePath = this.dir.getAbsolutePath();
            String _shellName = entity.getShellName();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath, "/", _shellName, ".sh"})), (CharSequence)"");
            File shellFile = new File(_join);
            boolean _exists = shellFile.exists();
            if (_exists) {
                ArrayList results = new ArrayList();
                ShellExecute.ShellCallback _function = it -> results.add(it);
                ShellExecute.start(entity.getTaskName(), _function, "bash", shellFile.getAbsolutePath());
                entity.setResults(IterableExtensions.join(results, (CharSequence)""));
                this.dao.deleteOneTask(entity.getTaskId());
                this.dao.saveTask(entity);
            }
        }
        if (!_matched) {
            int _ordinal_1 = TaskEntity.ShellType.BatchFile.ordinal();
            if (Objects.equal((Object)_shellType, (Object)_ordinal_1)) {
                _matched = true;
                String _absolutePath_1 = this.dir.getAbsolutePath();
                String _shellName_1 = entity.getShellName();
                String _join_1 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath_1, "/", _shellName_1, ".bat"})), (CharSequence)"");
                File shellFile_1 = new File(_join_1);
                boolean _exists_1 = shellFile_1.exists();
                if (_exists_1) {
                    ArrayList results_1 = new ArrayList();
                    ShellExecute.ShellCallback _function_1 = it -> results_1.add(it);
                    ShellExecute.start(entity.getTaskName(), _function_1, "cmd", shellFile_1.getAbsolutePath());
                    entity.setResults(IterableExtensions.join(results_1, (CharSequence)""));
                    this.dao.deleteOneTask(entity.getTaskId());
                    this.dao.saveTask(entity);
                }
            }
        }
        if (!_matched) {
            int _ordinal_2 = TaskEntity.ShellType.Groovy.ordinal();
            if (Objects.equal((Object)_shellType, (Object)_ordinal_2)) {
                _matched = true;
            }
        }
        if (!_matched) {
            int _ordinal_3 = TaskEntity.ShellType.JavaScript.ordinal();
            if (Objects.equal((Object)_shellType, (Object)_ordinal_3)) {
                _matched = true;
            }
        }
        if (!_matched) {
            // empty if block
        }
        return Response.ok().build();
    }

    @Override
    public Response exitTask(String uuid) {
        TaskEntity e = this.dao.getOneTask(uuid);
        return Response.ok().build();
    }

    @Override
    public Response getTaskType() {
        TaskEntity.TaskType[] _values = TaskEntity.TaskType.values();
        Pair _mappedTo = Pair.of((Object)"task_type", (Object)_values);
        Function<TaskEntity.TaskType, Integer> _function = it -> it.ordinal();
        List _collect = ((List)Conversions.doWrapArray((Object)TaskEntity.TaskType.values())).stream().map(_function).collect(Collectors.toList());
        Pair _mappedTo_1 = Pair.of((Object)"task_type_ordinal", _collect);
        TaskEntity.ShellType[] _values_1 = TaskEntity.ShellType.values();
        Pair _mappedTo_2 = Pair.of((Object)"shell_type", (Object)_values_1);
        Function<TaskEntity.ShellType, Integer> _function_1 = it -> it.ordinal();
        List _collect_1 = ((List)Conversions.doWrapArray((Object)TaskEntity.ShellType.values())).stream().map(_function_1).collect(Collectors.toList());
        Pair _mappedTo_3 = Pair.of((Object)"shell_type_ordinal", _collect_1);
        return Response.ok(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3}))).build();
    }
}

