package cool.taomu.box.job.server.controller.impl;

import com.google.common.base.Objects;
import cool.taomu.box.job.server.controller.inter.ITaskController;
import cool.taomu.box.job.server.dao.TaskDao;
import cool.taomu.box.job.server.entity.TaskEntity;
import cool.taomu.box.job.server.utils.ShellExecute;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Path("job")
@SuppressWarnings("all")
public class TaskController implements ITaskController<TaskEntity> {
  @Inject
  private TaskDao dao;
  
  private File dir = new File((System.getProperty("user.dir") + "/script/"));
  
  @Override
  public Response getTask(final String uuid) {
    TaskEntity entity = this.dao.getOneTask(uuid);
    return Response.ok(entity).build();
  }
  
  @Override
  public Response putTask(final String uuid, final TaskEntity entity) {
    TaskEntity e = this.dao.getOneTask(uuid);
    entity.setTaskId(e.getTaskId());
    this.dao.deleteOneTask(e.getTaskId());
    this.dao.saveTask(e);
    return Response.ok(entity).build();
  }
  
  @Override
  public Response deleteTask(final String uuid) {
    this.dao.deleteOneTask(uuid);
    return Response.ok().build();
  }
  
  @Override
  public Response postTask(final TaskEntity entity) {
    try {
      int _saveTask = this.dao.saveTask(entity);
      boolean _greaterThan = (_saveTask > 0);
      if (_greaterThan) {
        boolean _exists = this.dir.exists();
        boolean _not = (!_exists);
        if (_not) {
          this.dir.mkdirs();
        }
        int _shellType = entity.getShellType();
        boolean _matched = false;
        int _ordinal = TaskEntity.ShellType.Shell.ordinal();
        if (Objects.equal(_shellType, _ordinal)) {
          _matched=true;
          String _absolutePath = this.dir.getAbsolutePath();
          String _shellName = entity.getShellName();
          String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath, "/", _shellName, ".sh")), "");
          File _file = new File(_join);
          FileUtils.writeStringToFile(_file, 
            entity.getShell(), "UTF-8", false);
        }
        if (!_matched) {
          int _ordinal_1 = TaskEntity.ShellType.BatchFile.ordinal();
          if (Objects.equal(_shellType, _ordinal_1)) {
            _matched=true;
            String _absolutePath_1 = this.dir.getAbsolutePath();
            String _shellName_1 = entity.getShellName();
            String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath_1, "/", _shellName_1, ".bat")), "");
            File _file_1 = new File(_join_1);
            FileUtils.writeStringToFile(_file_1, 
              entity.getShell(), "UTF-8", false);
          }
        }
        if (!_matched) {
          int _ordinal_2 = TaskEntity.ShellType.Groovy.ordinal();
          if (Objects.equal(_shellType, _ordinal_2)) {
            _matched=true;
            String _absolutePath_2 = this.dir.getAbsolutePath();
            String _shellName_2 = entity.getShellName();
            String _join_2 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath_2, "/", _shellName_2, ".groovy")), "");
            File _file_2 = new File(_join_2);
            FileUtils.writeStringToFile(_file_2, entity.getShell(), "UTF-8", 
              false);
          }
        }
        if (!_matched) {
          int _ordinal_3 = TaskEntity.ShellType.JavaScript.ordinal();
          if (Objects.equal(_shellType, _ordinal_3)) {
            _matched=true;
            String _absolutePath_3 = this.dir.getAbsolutePath();
            String _shellName_3 = entity.getShellName();
            String _join_3 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath_3, "/", _shellName_3, ".js")), "");
            File _file_3 = new File(_join_3);
            FileUtils.writeStringToFile(_file_3, 
              entity.getShell(), "UTF-8", false);
          }
        }
        if (!_matched) {
          return Response.status(500).build();
        }
        return Response.status(201).build();
      }
      return Response.status(304).build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public Response runTask(final String uuid) {
    TaskEntity entity = this.dao.getOneTask(uuid);
    int _shellType = entity.getShellType();
    boolean _matched = false;
    int _ordinal = TaskEntity.ShellType.Shell.ordinal();
    if (Objects.equal(_shellType, _ordinal)) {
      _matched=true;
      String _absolutePath = this.dir.getAbsolutePath();
      String _shellName = entity.getShellName();
      String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath, "/", _shellName, ".sh")), "");
      File shellFile = new File(_join);
      boolean _exists = shellFile.exists();
      if (_exists) {
        final ArrayList<String> results = new ArrayList<String>();
        final ShellExecute.ShellCallback _function = (String it) -> {
          results.add(it);
        };
        ShellExecute.start(entity.getTaskName(), _function, "bash", shellFile.getAbsolutePath());
        entity.setResults(IterableExtensions.join(results, ""));
        this.dao.deleteOneTask(entity.getTaskId());
        this.dao.saveTask(entity);
      }
    }
    if (!_matched) {
      int _ordinal_1 = TaskEntity.ShellType.BatchFile.ordinal();
      if (Objects.equal(_shellType, _ordinal_1)) {
        _matched=true;
        String _absolutePath_1 = this.dir.getAbsolutePath();
        String _shellName_1 = entity.getShellName();
        String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath_1, "/", _shellName_1, ".bat")), "");
        File shellFile_1 = new File(_join_1);
        boolean _exists_1 = shellFile_1.exists();
        if (_exists_1) {
          final ArrayList<String> results_1 = new ArrayList<String>();
          final ShellExecute.ShellCallback _function_1 = (String it) -> {
            results_1.add(it);
          };
          ShellExecute.start(entity.getTaskName(), _function_1, "cmd", shellFile_1.getAbsolutePath());
          entity.setResults(IterableExtensions.join(results_1, ""));
          this.dao.deleteOneTask(entity.getTaskId());
          this.dao.saveTask(entity);
        }
      }
    }
    if (!_matched) {
      int _ordinal_2 = TaskEntity.ShellType.Groovy.ordinal();
      if (Objects.equal(_shellType, _ordinal_2)) {
        _matched=true;
      }
    }
    if (!_matched) {
      int _ordinal_3 = TaskEntity.ShellType.JavaScript.ordinal();
      if (Objects.equal(_shellType, _ordinal_3)) {
        _matched=true;
      }
    }
    if (!_matched) {
    }
    return Response.ok().build();
  }
  
  @Override
  public Response exitTask(final String uuid) {
    TaskEntity e = this.dao.getOneTask(uuid);
    return Response.ok().build();
  }
  
  @Override
  public Response getTaskType() {
    TaskEntity.TaskType[] _values = TaskEntity.TaskType.values();
    Pair<String, TaskEntity.TaskType[]> _mappedTo = Pair.<String, TaskEntity.TaskType[]>of("task_type", _values);
    final Function<TaskEntity.TaskType, Integer> _function = (TaskEntity.TaskType it) -> {
      return Integer.valueOf(it.ordinal());
    };
    List<Integer> _collect = ((List<TaskEntity.TaskType>)Conversions.doWrapArray(TaskEntity.TaskType.values())).stream().<Integer>map(_function).collect(Collectors.<Integer>toList());
    Pair<String, List<Integer>> _mappedTo_1 = Pair.<String, List<Integer>>of("task_type_ordinal", _collect);
    TaskEntity.ShellType[] _values_1 = TaskEntity.ShellType.values();
    Pair<String, TaskEntity.ShellType[]> _mappedTo_2 = Pair.<String, TaskEntity.ShellType[]>of("shell_type", _values_1);
    final Function<TaskEntity.ShellType, Integer> _function_1 = (TaskEntity.ShellType it) -> {
      return Integer.valueOf(it.ordinal());
    };
    List<Integer> _collect_1 = ((List<TaskEntity.ShellType>)Conversions.doWrapArray(TaskEntity.ShellType.values())).stream().<Integer>map(_function_1).collect(Collectors.<Integer>toList());
    Pair<String, List<Integer>> _mappedTo_3 = Pair.<String, List<Integer>>of("shell_type_ordinal", _collect_1);
    return Response.ok(
      Collections.<Pair<String, ?>>unmodifiableList(CollectionLiterals.<Pair<String, ?>>newArrayList(_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3))).build();
  }
}
