package cool.taomu.box.job.server.dao;

import cool.taomu.box.job.server.dao.provider.MqttUserDaoProvider;
import cool.taomu.box.job.server.entity.MqttSubscribeEntity;
import cool.taomu.box.job.server.entity.MqttUserEntity;
import java.util.List;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;

@Mapper
@SuppressWarnings("all")
public interface MqttUserDao {
  @Insert("insert into taomubox_mqtt_user(clientid,online,\"enable\") values(#{clientId},#{online},#{enable})")
  int addUser(@Param("clientId") final String clientId, @Param("online") final int online, @Param("enable") final int enable);
  
  @InsertProvider(type = MqttUserDaoProvider.class, method = "insert")
  int addUser22(@Param("t") final MqttUserEntity t);
  
  @SelectProvider(type = MqttUserDaoProvider.class, method = "select")
  List<MqttUserEntity> getUser22(@Param("t") final MqttUserEntity t);
  
  @Select("delete from taomubox_mqtt_user where clientid=#{clientId}")
  int deleteByClientId(@Param("clientId") final String clientId);
  
  @Select("select * from taomubox_mqtt_user where clientid=#{clientId}")
  MqttUserEntity selectByClientId(@Param("clientId") final String clientId);
  
  @Select("select * from taomubox_mqtt_user")
  List<MqttUserEntity> selectAll();
  
  @Select("select * from taomubox_mqtt_subscribe where clientid=#{clientId}")
  List<MqttSubscribeEntity> selectSubscribeByClientId(@Param("clientId") final String clientId);
  
  @Select("select * from taomubox_mqtt_subscribe")
  List<MqttSubscribeEntity> selectSubscribeAll();
}
