package cool.taomu.box.job.server.dao;

import cool.taomu.box.job.server.dao.provider.TaskDaoProvider;
import cool.taomu.box.job.server.entity.TaskEntity;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@Mapper
@SuppressWarnings("all")
public interface TaskDao {
  @Result(property = "type", column = "type", javaType = TaskEntity.TaskType.class, jdbcType = JdbcType.INTEGER, typeHandler = EnumOrdinalTypeHandler.class)
  @Result(property = "shellType", column = "shell_type", javaType = TaskEntity.ShellType.class, jdbcType = JdbcType.INTEGER, typeHandler = EnumOrdinalTypeHandler.class)
  @Result(property = "status", column = "STATUS", javaType = TaskEntity.TaskStatus.class, jdbcType = JdbcType.INTEGER, typeHandler = EnumOrdinalTypeHandler.class)
  @Select("select * from taomu_job_task where taskId=#{taskId}")
  TaskEntity getOneTask(@Param("taskId") final String taskId);
  
  @InsertProvider(type = TaskDaoProvider.class, method = "insert")
  int saveTask(@Param("t") final TaskEntity entity);
  
  @Delete("delete from taomu_job_task where taskId=#{taskId}")
  int deleteOneTask(@Param("taskId") final String taskId);
}
