/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.utils;

import cool.taomu.box.job.server.entity.TaskEntity;
import java.io.File;
import java.util.Collections;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class GetTaskDirectory {
  public static File getScriptPath(final TaskEntity entity, final String fileName) {
    if ((fileName != null)) {
      String _trim = entity.getTaskDirectory().trim();
      String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "/script/", fileName)), "");
      return new File(_join);
    }
    String _trim_1 = entity.getTaskDirectory().trim();
    String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "/script/")), "");
    return new File(_join_1);
  }
  
  public static File getResultPath(final TaskEntity entity, final String fileName) {
    if ((fileName != null)) {
      String _trim = entity.getTaskDirectory().trim();
      String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "/results/", fileName)), "");
      return new File(_join);
    }
    String _trim_1 = entity.getTaskDirectory().trim();
    String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "/results/")), "");
    return new File(_join_1);
  }
  
  public static File getTemplatePath(final TaskEntity entity, final String fileName) {
    if ((fileName != null)) {
      String _trim = entity.getTaskDirectory().trim();
      String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "/template/", fileName)), "");
      return new File(_join);
    }
    String _trim_1 = entity.getTaskDirectory().trim();
    String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "/template/")), "");
    return new File(_join_1);
  }
  
  public static File getAnalysisPath(final TaskEntity entity, final String fileName) {
    if ((fileName != null)) {
      String _trim = entity.getTaskDirectory().trim();
      String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "/template/analysis/", fileName)), "");
      return new File(_join);
    }
    String _trim_1 = entity.getTaskDirectory().trim();
    String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "/template/analysis/")), "");
    return new File(_join_1);
  }
}
