/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Pair;

@SuppressWarnings("all")
public class ShellExecute implements Runnable {
  public interface ShellCallback {
    void callback(final String line);
  }
  
  private static final Map<String, Process> processMap = new HashMap<String, Process>();
  
  public static void main(final String[] args) {
    Pair<String, String> _mappedTo = Pair.<String, String>of("AA", "Hello World");
    Map<String, String> a = Collections.<String, String>unmodifiableMap(CollectionLiterals.<String, String>newHashMap(_mappedTo));
    final ShellExecute.ShellCallback _function = (String it) -> {
      InputOutput.<String>println(it);
    };
    ShellExecute.start("Firefox", _function, a, "/bin/bash", "-c", "echo $AA");
  }
  
  public static void start(final String name, final ShellExecute.ShellCallback call, final Map<String, String> env, final String... args) {
    try {
      ProcessBuilder pb = new ProcessBuilder();
      if ((env != null)) {
        pb.environment().putAll(env);
      }
      pb.command(args);
      Process p = pb.start();
      InputStream _inputStream = p.getInputStream();
      InputStreamReader _inputStreamReader = new InputStreamReader(_inputStream);
      BufferedReader reader = new BufferedReader(_inputStreamReader);
      String line = null;
      while (((line = reader.readLine()) != null)) {
        call.callback(line);
      }
      int exitVal = p.waitFor();
      if ((exitVal == 0)) {
        call.callback("Success!");
      } else {
        InputStream _errorStream = p.getErrorStream();
        InputStreamReader _inputStreamReader_1 = new InputStreamReader(_errorStream);
        BufferedReader errorReader = new BufferedReader(_inputStreamReader_1);
        while (((line = errorReader.readLine()) != null)) {
          call.callback(line);
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof IOException || _t instanceof InterruptedException) {
        final Exception e = (Exception)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  @Override
  public void run() {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
}
