/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;

import cool.taomu.box.ioc.guice.TaomuGuiceModule;
import cool.taomu.box.jersery.jetty.JsereyJettyServer;
import cool.taomu.box.job.server.config.MqttServerConfig;
import cool.taomu.box.job.server.config.OAuth2Config;
import cool.taomu.box.netty.NettyServer;

public class TaomuboxJobServer {

	@Inject
	JsereyJettyServer jetty;

	@Inject
	NettyServer server;

	public static void main(String args[]) throws Exception {
		Module m = new TaomuGuiceModule().build(OAuth2Config.class, MqttServerConfig.class);
		Injector injector = Guice.createInjector(m);
		TaomuboxJobServer s = injector.getInstance(TaomuboxJobServer.class);
		s.jetty.start();
		s.server.start();
	}
}
