package cool.taomu.box.job.server.utils;

import cool.taomu.box.git.JGitTools;
import java.util.ArrayList;

@SuppressWarnings("all")
public class GitFileHistory {
  private String basePath;
  
  private JGitTools jgit;
  
  public GitFileHistory(final JGitTools jgit, final String basePath) {
    this.basePath = basePath;
    this.jgit = jgit;
  }
  
  private ArrayList<String> commitIds(final int num) {
    final ArrayList<String> list = new ArrayList<String>();
    final JGitTools.GitCallback _function = (String it) -> {
      list.add(it);
    };
    this.jgit.getCommitIds(this.basePath, Integer.valueOf(num), _function);
    return list;
  }
  
  public void get(final String path, final int num, final JGitTools.GitCallback call) {
    ArrayList<String> cids = this.commitIds(num);
    this.jgit.retrieveFileContent(this.basePath, path, cids, call);
  }
}
