package cool.taomu.box.job.server.service;

import cool.taomu.box.job.server.dao.TaskDao;
import cool.taomu.box.job.server.entity.TaskEntity;
import java.util.List;
import javax.inject.Inject;

@SuppressWarnings("all")
public class TaskService {
  @Inject
  private TaskDao dao;
  
  public TaskEntity getOneTask(final String taskId) {
    return this.dao.getOneTask(taskId);
  }
  
  public int deleteOneTask(final String taskId) {
    return this.dao.deleteOneTask(taskId);
  }
  
  public int update(final TaskEntity entity) {
    int _xblockexpression = (int) 0;
    {
      this.dao.deleteOneTask(entity.getTaskId());
      _xblockexpression = this.dao.saveTask(entity);
    }
    return _xblockexpression;
  }
  
  public TaskEntity getOneTaskByTaskName(final String taskName) {
    return this.dao.getOneTaskByTaskName(taskName);
  }
  
  public int saveTask(final TaskEntity entity) {
    return this.dao.saveTask(entity);
  }
  
  public List<TaskEntity> getTaskAll() {
    return this.dao.getTaskAll();
  }
}
