/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.utils;

import cool.taomu.box.job.server.entity.TaskEntity;
import java.io.File;
import java.util.Collections;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class GetTaskDirectory {
  private static final Logger LOG = LoggerFactory.getLogger(GetTaskDirectory.class);
  
  public static File getScriptPath(final TaskEntity entity, final String fileName) {
    String _trim = entity.getTaskDirectory().trim();
    String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "script")), File.separator);
    File file = new File(_join);
    boolean _exists = file.exists();
    boolean _not = (!_exists);
    if (_not) {
      boolean _mkdirs = file.mkdirs();
      if (_mkdirs) {
        GetTaskDirectory.LOG.info("创建目录:{}", file.getAbsolutePath());
      }
    }
    if ((fileName != null)) {
      String _trim_1 = entity.getTaskDirectory().trim();
      String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "script", fileName)), File.separator);
      File _file = new File(_join_1);
      file = _file;
    }
    return file;
  }
  
  public static File getScriptResultPath(final TaskEntity entity, final String fileName) {
    String _trim = entity.getTaskDirectory().trim();
    String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "script", "results")), File.separator);
    File file = new File(_join);
    boolean _exists = file.exists();
    boolean _not = (!_exists);
    if (_not) {
      boolean _mkdirs = file.mkdirs();
      if (_mkdirs) {
        GetTaskDirectory.LOG.info("创建目录:{}", file.getAbsolutePath());
      }
    }
    if ((fileName != null)) {
      String _trim_1 = entity.getTaskDirectory().trim();
      String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "script", "results", fileName)), File.separator);
      File _file = new File(_join_1);
      file = _file;
    }
    return file;
  }
  
  public static File getResultPath(final TaskEntity entity, final String fileName) {
    String _trim = entity.getTaskDirectory().trim();
    String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "results")), File.separator);
    File file = new File(_join);
    boolean _exists = file.exists();
    boolean _not = (!_exists);
    if (_not) {
      boolean _mkdirs = file.mkdirs();
      if (_mkdirs) {
        GetTaskDirectory.LOG.info("创建目录:{}", file.getAbsolutePath());
      }
    }
    if ((fileName != null)) {
      String _trim_1 = entity.getTaskDirectory().trim();
      String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "results", fileName)), File.separator);
      File _file = new File(_join_1);
      file = _file;
    }
    return file;
  }
  
  public static File getTemplatePath(final TaskEntity entity, final String fileName) {
    String _trim = entity.getTaskDirectory().trim();
    String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "template")), File.separator);
    File file = new File(_join);
    boolean _exists = file.exists();
    boolean _not = (!_exists);
    if (_not) {
      boolean _mkdirs = file.mkdirs();
      if (_mkdirs) {
        GetTaskDirectory.LOG.info("创建目录:{}", file.getAbsolutePath());
      }
    }
    if ((fileName != null)) {
      String _trim_1 = entity.getTaskDirectory().trim();
      String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "template", fileName)), File.separator);
      File _file = new File(_join_1);
      file = _file;
    }
    return file;
  }
  
  public static File getAnalysisPath(final TaskEntity entity, final String fileName) {
    String _trim = entity.getTaskDirectory().trim();
    String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, "template", "analysis")), File.separator);
    File file = new File(_join);
    boolean _exists = file.exists();
    boolean _not = (!_exists);
    if (_not) {
      boolean _mkdirs = file.mkdirs();
      if (_mkdirs) {
        GetTaskDirectory.LOG.info("创建目录:{}", file.getAbsolutePath());
      }
    }
    if ((fileName != null)) {
      String _trim_1 = entity.getTaskDirectory().trim();
      String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, "template", "analysis", fileName)), File.separator);
      File _file = new File(_join_1);
      file = _file;
    }
    return file;
  }
}
