package cool.taomu.box.job.server.controller.inter;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@SuppressWarnings("all")
public interface ITaskController<T extends Object> {
  @GET
  @Path("/task/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  Response getTask(@PathParam("taskId") final String uuid);
  
  @PUT
  @Path("/task/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  Response putTask(@PathParam("taskId") final String uuid, final T entity);
  
  @DELETE
  @Path("/task/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  Response deleteTask(@PathParam("taskId") final String uuid);
  
  @POST
  @Path("/task")
  @Consumes(MediaType.APPLICATION_JSON)
  Response postTask(final T entity);
  
  @GET
  @Path("/task/run/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  Response runTask(@PathParam("taskId") final String uuid);
  
  @GET
  @Path("/task/result/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  Response getTaskResult(@PathParam("taskId") final String uuid);
  
  @DELETE
  @Path("/task/run/{taskId}")
  @Consumes(MediaType.APPLICATION_JSON)
  Response exitTask(@PathParam("taskId") final String uuid);
  
  @GET
  @Path("/task/type")
  @Consumes(MediaType.APPLICATION_JSON)
  Response getTaskType();
  
  @GET
  @Path("/task/status")
  @Consumes(MediaType.APPLICATION_JSON)
  Response getTaskStatus(final String uuid);
  
  @GET
  @Path("/task/list")
  @Consumes(MediaType.APPLICATION_JSON)
  Response getTaskList();
}
