/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.dao;

import cool.taomu.box.job.server.entity.OAuth2UserEntity;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
@SuppressWarnings("all")
public interface OAuth2UserDao {
  @Update("update taomubox_oauth2_user set code=#{code} where clientid=#{clientId}")
  int updateByClientId(@Param("code") final String code, @Param("clientId") final String id);
  
  @Update("insert into taomubox_oauth2_user(uuid,clientid,clientsecret,callbackurl) values(#{uuid},#{clientId},#{clientSecret},#{callbackurl})")
  int insert(@Param("uuid") final String uuid, @Param("clientId") final String id, @Param("clientSecret") final String secret, @Param("callbackurl") final String callbackurl);
  
  @Select("select * from taomubox_oauth2_user where clientid=#{clientId} and clientsecret=#{clientSecret}")
  OAuth2UserEntity selectByClientIdAndClientSecret(@Param("clientId") final String clientId, @Param("clientSecret") final String clientSecret);
  
  @Select("select * from taomubox_oauth2_user")
  List<OAuth2UserEntity> selectAll();
}
