/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.entity;

import cool.taomu.box.mybatis.plus.ann.Column;
import cool.taomu.box.mybatis.plus.ann.Table;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@Table("TAOMUBOX_JOB_TASK")
@SuppressWarnings("all")
public class TaskEntity {
  public enum TaskType {
    SHELL,
    
    TOPIC,
    
    REMOTE,
    
    SSH;
  }
  
  public enum TaskStatus {
    FAIL,
    
    SUCCESS,
    
    WAIT,
    
    READY,
    
    IN_PROGRESS,
    
    DONE,
    
    UNKNOWN;
  }
  
  public enum ShellType {
    None,
    
    JavaScript,
    
    Groovy,
    
    Bsh,
    
    Shell,
    
    BatchFile,
    
    Jython,
    
    JRuby,
    
    Python,
    
    Ruby,
    
    NodeJS;
  }
  
  @Column(value = "\"type\"")
  private int type;
  
  @Column(value = "shell_type")
  private int shellType = TaskEntity.ShellType.None.ordinal();
  
  @Column(value = "task_id")
  private String taskId;
  
  @Column(value = "client_id")
  private String clientId;
  
  @Column(value = "task_name")
  private String taskName = "unknown";
  
  @Column(value = "STATUS")
  private int status = TaskEntity.TaskStatus.UNKNOWN.ordinal();
  
  @Column(value = "RUN_TIMESTMAP")
  private long runTimestamp = 0;
  
  @Column(value = "TASK_ADD_TIMESTAMP")
  private long taskAddTimestmap = 0;
  
  @Column(value = "schedule")
  private String schedule = "";
  
  @Column(value = "is_schedule_task")
  private boolean isScheduledTask = false;
  
  @Column(value = "\"parameter\"")
  private String parameter = "";
  
  @Column(value = "shell_path")
  private String shellPath = "";
  
  private String shellText = "";
  
  @Column(value = "task_version")
  private Integer taskVersion;
  
  @Column(value = "exception_info")
  private String exceptionInfo = "";
  
  @Column(value = "html_template")
  private String htmlTemplate = "";
  
  @Column(value = "EXTEND_COLUMN")
  private String extendColumn;
  
  @Column(value = "task_directory")
  private String taskDirectory;
  
  @Pure
  public int getType() {
    return this.type;
  }
  
  public void setType(final int type) {
    this.type = type;
  }
  
  @Pure
  public int getShellType() {
    return this.shellType;
  }
  
  public void setShellType(final int shellType) {
    this.shellType = shellType;
  }
  
  @Pure
  public String getTaskId() {
    return this.taskId;
  }
  
  public void setTaskId(final String taskId) {
    this.taskId = taskId;
  }
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Pure
  public String getTaskName() {
    return this.taskName;
  }
  
  public void setTaskName(final String taskName) {
    this.taskName = taskName;
  }
  
  @Pure
  public int getStatus() {
    return this.status;
  }
  
  public void setStatus(final int status) {
    this.status = status;
  }
  
  @Pure
  public long getRunTimestamp() {
    return this.runTimestamp;
  }
  
  public void setRunTimestamp(final long runTimestamp) {
    this.runTimestamp = runTimestamp;
  }
  
  @Pure
  public long getTaskAddTimestmap() {
    return this.taskAddTimestmap;
  }
  
  public void setTaskAddTimestmap(final long taskAddTimestmap) {
    this.taskAddTimestmap = taskAddTimestmap;
  }
  
  @Pure
  public String getSchedule() {
    return this.schedule;
  }
  
  public void setSchedule(final String schedule) {
    this.schedule = schedule;
  }
  
  @Pure
  public boolean isScheduledTask() {
    return this.isScheduledTask;
  }
  
  public void setIsScheduledTask(final boolean isScheduledTask) {
    this.isScheduledTask = isScheduledTask;
  }
  
  @Pure
  public String getParameter() {
    return this.parameter;
  }
  
  public void setParameter(final String parameter) {
    this.parameter = parameter;
  }
  
  @Pure
  public String getShellPath() {
    return this.shellPath;
  }
  
  public void setShellPath(final String shellPath) {
    this.shellPath = shellPath;
  }
  
  @Pure
  public String getShellText() {
    return this.shellText;
  }
  
  public void setShellText(final String shellText) {
    this.shellText = shellText;
  }
  
  @Pure
  public Integer getTaskVersion() {
    return this.taskVersion;
  }
  
  public void setTaskVersion(final Integer taskVersion) {
    this.taskVersion = taskVersion;
  }
  
  @Pure
  public String getExceptionInfo() {
    return this.exceptionInfo;
  }
  
  public void setExceptionInfo(final String exceptionInfo) {
    this.exceptionInfo = exceptionInfo;
  }
  
  @Pure
  public String getHtmlTemplate() {
    return this.htmlTemplate;
  }
  
  public void setHtmlTemplate(final String htmlTemplate) {
    this.htmlTemplate = htmlTemplate;
  }
  
  @Pure
  public String getExtendColumn() {
    return this.extendColumn;
  }
  
  public void setExtendColumn(final String extendColumn) {
    this.extendColumn = extendColumn;
  }
  
  @Pure
  public String getTaskDirectory() {
    return this.taskDirectory;
  }
  
  public void setTaskDirectory(final String taskDirectory) {
    this.taskDirectory = taskDirectory;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("type", this.type);
    b.add("shellType", this.shellType);
    b.add("taskId", this.taskId);
    b.add("clientId", this.clientId);
    b.add("taskName", this.taskName);
    b.add("status", this.status);
    b.add("runTimestamp", this.runTimestamp);
    b.add("taskAddTimestmap", this.taskAddTimestmap);
    b.add("schedule", this.schedule);
    b.add("isScheduledTask", this.isScheduledTask);
    b.add("parameter", this.parameter);
    b.add("shellPath", this.shellPath);
    b.add("shellText", this.shellText);
    b.add("taskVersion", this.taskVersion);
    b.add("exceptionInfo", this.exceptionInfo);
    b.add("htmlTemplate", this.htmlTemplate);
    b.add("extendColumn", this.extendColumn);
    b.add("taskDirectory", this.taskDirectory);
    return b.toString();
  }
}
