package cool.taomu.box.job.server.utils;

import cool.taomu.box.git.JGitTools;
import cool.taomu.box.git.entity.GitCommitInfoEntity;
import cool.taomu.box.git.entity.GitFileHistoryContentEntity;
import cool.taomu.box.utils.inter.ICallback;
import java.util.ArrayList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class GitFileHistory {
  private String basePath;
  
  private String filePath = null;
  
  private JGitTools jgit;
  
  public GitFileHistory(final JGitTools jgit, final String basePath) {
    this.basePath = basePath;
    this.jgit = jgit;
    this.jgit.setRepository(basePath);
  }
  
  private ArrayList<GitCommitInfoEntity> commitIds(final int num) {
    final ArrayList<GitCommitInfoEntity> list = new ArrayList<GitCommitInfoEntity>();
    final ICallback<GitCommitInfoEntity> _function = (GitCommitInfoEntity it) -> {
      list.add(it);
    };
    this.jgit.getCommitIds(Integer.valueOf(num), _function);
    return list;
  }
  
  public GitFileHistory setFilePath(final String path) {
    this.filePath = path;
    return this;
  }
  
  public void get(final int num, final ICallback<GitFileHistoryContentEntity> call) {
    ArrayList<GitCommitInfoEntity> cids = this.commitIds(num);
    final Function1<GitCommitInfoEntity, String> _function = (GitCommitInfoEntity it) -> {
      return it.getId();
    };
    this.jgit.retrieveFileContent(this.filePath, ListExtensions.<GitCommitInfoEntity, String>map(cids, _function), call);
  }
}
