/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.controller;

import cool.taomu.box.job.server.dao.MqttUserDao;
import cool.taomu.box.job.server.entity.MqttSubscribeEntity;
import cool.taomu.box.job.server.entity.MqttUserEntity;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="job/mqtt/user")
public class MqttUserController {
    @Inject
    private MqttUserDao userDao;

    @GET
    @Path(value="/subscribe")
    @Produces(value={"application/json"})
    public List<MqttSubscribeEntity> subscribe() {
        return this.userDao.selectSubscribeAll();
    }

    @GET
    @Path(value="/subscribe/{clientid}")
    @Produces(value={"application/json"})
    public List<MqttSubscribeEntity> subscribeOne(@PathParam(value="clientid") String cid) {
        return this.userDao.selectSubscribeByClientId(cid);
    }

    @GET
    @Path(value="{clientid}")
    @Produces(value={"application/json"})
    public MqttUserEntity getUser(@PathParam(value="clientid") String cid) {
        return this.userDao.selectByClientId(cid);
    }

    @GET
    @Produces(value={"application/json"})
    public List<MqttUserEntity> getUserAll() {
        return this.userDao.selectAll();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String addUser(MqttUserEntity body) {
        String _xblockexpression = null;
        this.userDao.addUser(body.getClientId(), body.getOnline(), body.getEnable());
        _xblockexpression = "";
        return _xblockexpression;
    }

    @PUT
    @Path(value="{clientid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String moidfyUser(@PathParam(value="clientid") String cid, MqttUserEntity body) {
        return null;
    }

    @DELETE
    @Path(value="{clientid}")
    @Produces(value={"text/plain"})
    public String delUser(@PathParam(value="clientid") String cid) {
        String _xblockexpression = null;
        this.userDao.deleteByClientId(cid);
        _xblockexpression = "";
        return _xblockexpression;
    }
}

