/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.controller.impl;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.controller.abs.AbsPreTaskAndPostTask;
import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.controller.entity.HtmlTemplateEntity;
import cool.taomu.box.job.server.controller.entity.ResponseEntity;
import cool.taomu.box.job.server.controller.entity.TaskExtendColumnEntity;
import cool.taomu.box.job.server.controller.entity.TaskResultEntity;
import cool.taomu.box.job.server.controller.inter.ITaskController;
import cool.taomu.box.job.server.entity.TaskEntity;
import cool.taomu.box.job.server.service.TaskService;
import cool.taomu.box.job.server.utils.ChineseToPinyin;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.job.server.utils.GitFileHistory;
import cool.taomu.box.job.server.utils.MarkdownUtils;
import cool.taomu.box.job.server.utils.ShellExecute;
import cool.taomu.box.script.rhino.JsRhinoScript;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback2;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="job")
public class TaskController
implements ITaskController<TaskEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskController.class);
    @Inject
    private TaskService taskService;
    @Inject
    private JGitTools jgit;
    @Inject
    private AbsPreTaskAndPostTask iTask;

    @Override
    public Response getTask(String uuid) {
        try {
            LOG.info("\u83b7\u53d6 {} ID\u7684\u4efb\u52a1", (Object)uuid);
            TaskEntity entity = this.taskService.getOneTask(uuid);
            HtmlTemplateEntity htemplate = (HtmlTemplateEntity)new Gson().fromJson(entity.getHtmlTemplate(), HtmlTemplateEntity.class);
            Consumer<HtmlTemplateEntity.DataEntity> _function = it -> {
                try {
                    LOG.info("mustache path:{}", (Object)it.getMustachePath());
                    LOG.info("mustache path:{}", (Object)it.getAnalysisShellPath());
                    String _mustachePath = it.getMustachePath();
                    File tempFile = new File(_mustachePath);
                    it.setMustacheText(FileUtils.readFileToString((File)tempFile, (String)"UTF-8"));
                    String _analysisShellPath = it.getAnalysisShellPath();
                    File _file = new File(_analysisShellPath);
                    it.setAnalysisShellText(FileUtils.readFileToString((File)_file, (String)"UTF-8"));
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            htemplate.getData().forEach(_function);
            entity.setHtmlTemplate(new Gson().toJson((Object)htemplate));
            String shellPath = entity.getShellPath();
            LOG.info("shell path:{}", (Object)shellPath);
            File _file = new File(shellPath);
            entity.setShellText(FileUtils.readFileToString((File)_file, (String)"UTF-8"));
            return Response.ok((Object)entity).build();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Response putTask(String uuid, TaskEntity entity) {
        HtmlTemplateEntity inputHtemplate;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        LOG.info("\u4fee\u6539 {} ID\u7684\u4efb\u52a1", (Object)uuid);
        TaskEntity old = this.taskService.getOneTask(uuid);
        Integer _taskVersion = old.getTaskVersion();
        int _plus = _taskVersion + 1;
        old.setTaskVersion(_plus);
        ArrayList<FileWriteEntity> fileWriteList = new ArrayList<FileWriteEntity>();
        String _shellPath = old.getShellPath();
        String _shellText = entity.getShellText();
        FileWriteEntity _fileWriteEntity = new FileWriteEntity(_shellPath, _shellText);
        fileWriteList.add(_fileWriteEntity);
        HtmlTemplateEntity htemplate = (HtmlTemplateEntity)new Gson().fromJson(old.getHtmlTemplate(), HtmlTemplateEntity.class);
        this.jgit.setRepository(old.getTaskDirectory());
        boolean _isEmpty = htemplate.getData().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Consumer<HtmlTemplateEntity.DataEntity> _function = it -> {
                String mustachePath = it.getMustachePath();
                String analysisShellPath = it.getAnalysisShellPath();
                FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(mustachePath, "", FileWriteEntity.OperationType.RM);
                fileWriteList.add(_fileWriteEntity_1);
                FileWriteEntity _fileWriteEntity_2 = new FileWriteEntity(analysisShellPath, "", FileWriteEntity.OperationType.RM);
                fileWriteList.add(_fileWriteEntity_2);
            };
            htemplate.getData().forEach(_function);
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = (inputHtemplate = (HtmlTemplateEntity)new Gson().fromJson(entity.getHtmlTemplate(), HtmlTemplateEntity.class)).getData().isEmpty());
        if (_not_1) {
            String tempName = UUID.randomUUID().toString().replace("-", "");
            LOG.info("\u751f\u6210\u6a21\u677f\u6587\u4ef6:{}", (Object)tempName);
            LOG.info("\u6a21\u677f\u5185\u5bb9:{}", (Object)entity.getHtmlTemplate());
            Consumer<HtmlTemplateEntity.DataEntity> _function_1 = nit -> {
                nit.setPname(ChineseToPinyin.toPinyin(nit.getName()));
                String _pname = nit.getPname();
                File mustachePath = GetTaskDirectory.getTemplatePath(old, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pname, tempName, "mustache"})), (CharSequence)"."));
                nit.setMustachePath(mustachePath.getAbsolutePath().trim());
                String _pname_1 = nit.getPname();
                File analysis = GetTaskDirectory.getAnalysisPath(old, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pname_1, tempName, "js"})), (CharSequence)"."));
                nit.setAnalysisShellPath(analysis.getAbsolutePath().trim());
                String _absolutePath = mustachePath.getAbsolutePath();
                String _mustacheText = nit.getMustacheText();
                FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_absolutePath, _mustacheText);
                String _absolutePath_1 = analysis.getAbsolutePath();
                String _analysisShellText = nit.getAnalysisShellText();
                FileWriteEntity _fileWriteEntity_2 = new FileWriteEntity(_absolutePath_1, _analysisShellText);
                fileWriteList.addAll(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new FileWriteEntity[]{_fileWriteEntity_1, _fileWriteEntity_2})));
            };
            inputHtemplate.getData().forEach(_function_1);
            ICallback2 _function_2 = () -> fileWriteList;
            this.taskService.FileWrite(old.getTaskDirectory(), old.getTaskVersion(), (ICallback2<List<FileWriteEntity>>)_function_2);
        }
        old.setHtmlTemplate(new Gson().toJson((Object)inputHtemplate));
        old.setExtendColumn((String)StringUtils.defaultIfEmpty((CharSequence)entity.getExtendColumn(), (CharSequence)""));
        this.taskService.update(old);
        return Response.status((int)201).build();
    }

    @Override
    public Response deleteTask(String uuid) {
        boolean _not;
        LOG.info("\u5220\u9664\u4efb\u52a1:{}", (Object)uuid);
        TaskEntity oldTask = this.taskService.getOneTask(uuid);
        String _trim = oldTask.getTaskDirectory().trim();
        File dir = new File(_trim);
        LOG.info("\u8981\u5220\u9664\u7684\u76ee\u5f55\u4e3a: {}", (Object)dir.getAbsolutePath());
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)oldTask.getTaskDirectory());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            try {
                boolean _deleteQuietly = FileUtils.deleteQuietly((File)dir);
                if (_deleteQuietly) {
                    boolean _greaterThan;
                    LOG.info("\u5220\u9664\u4efb\u52a1 {} \u76ee\u5f55\u6210\u529f", (Object)dir.getAbsolutePath());
                    int _deleteOneTask = this.taskService.deleteOneTask(oldTask.getTaskId());
                    boolean bl2 = _greaterThan = _deleteOneTask > 0;
                    if (_greaterThan) {
                        LOG.info("\u5220\u9664\u4efb\u52a1 {} \u6210\u529f", (Object)uuid);
                        return Response.status((int)200).build();
                    }
                    LOG.info("\u5220\u9664\u4efb\u52a1 {} \u5931\u8d25", (Object)uuid);
                    return Response.status((int)402).build();
                }
                LOG.info("\u5220\u9664\u4efb\u52a1 {} \u76ee\u5f55\u5931\u8d25", (Object)dir.getAbsolutePath());
                return Response.status((int)402).build();
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    ex.printStackTrace();
                    return Response.status((int)500).build();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    @Override
    public Response postTask(TaskEntity entity) {
        boolean _greaterThan;
        boolean _mkdirs;
        boolean _not;
        TaskEntity sentity = this.taskService.getOneTaskByTaskName(entity.getTaskName());
        ArrayList<FileWriteEntity> fileWriteList = new ArrayList<FileWriteEntity>();
        if (sentity != null) {
            return Response.status((int)406).build();
        }
        entity.setTaskName(entity.getTaskName().trim());
        entity.setTaskVersion(0);
        String taskNamePinyin = ChineseToPinyin.toPinyin(entity.getTaskName());
        LOG.info("\u4efb\u52a1\u540d:{} \u8f6c\u4e3a\u62fc\u97f3:{}", (Object)entity.getTaskName(), (Object)taskNamePinyin);
        String _property = System.getProperty("user.dir");
        String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_property, taskNamePinyin})), (CharSequence)File.separator);
        File taskNameDir = new File(_join);
        entity.setTaskDirectory(taskNameDir.getAbsolutePath().trim());
        this.jgit.setRepository(entity.getTaskDirectory().trim());
        boolean _exists = taskNameDir.exists();
        boolean bl = _not = !_exists;
        if (_not && (_mkdirs = taskNameDir.mkdirs())) {
            LOG.info("\u521b\u5efa\u76ee\u5f55:{}", (Object)taskNameDir.getAbsolutePath());
            this.jgit.init();
        }
        LOG.info("\u4efb\u52a1\u76ee\u5f55:{}", (Object)taskNameDir);
        entity.setTaskId(UUID.randomUUID().toString());
        entity.setClientId(UUID.randomUUID().toString());
        GetTaskDirectory.getScriptPath(entity, null);
        GetTaskDirectory.getResultPath(entity, null);
        File tempdir = GetTaskDirectory.getTemplatePath(entity, null);
        boolean _exists_1 = tempdir.exists();
        if (_exists_1) {
            String tempName = UUID.randomUUID().toString().replace("-", "");
            LOG.info("\u751f\u6210\u6a21\u677f\u6587\u4ef6:{}", (Object)tempName);
            LOG.info("\u6a21\u677f\u5185\u5bb9:{}", (Object)entity.getHtmlTemplate());
            HtmlTemplateEntity htemplate = (HtmlTemplateEntity)new Gson().fromJson(entity.getHtmlTemplate(), HtmlTemplateEntity.class);
            InputOutput.println((Object)htemplate);
            Consumer<HtmlTemplateEntity.DataEntity> _function = nit -> {
                nit.setPname(ChineseToPinyin.toPinyin(nit.getName()));
                String _pname = nit.getPname();
                nit.setMustachePath(GetTaskDirectory.getTemplatePath(entity, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pname, tempName, "mustache"})), (CharSequence)".")).getAbsolutePath());
                String _pname_1 = nit.getPname();
                nit.setAnalysisShellPath(GetTaskDirectory.getAnalysisPath(entity, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pname_1, tempName, "js"})), (CharSequence)".")).getAbsolutePath());
                InputOutput.println((Object)nit.getMustacheText());
                InputOutput.println((Object)nit.getAnalysisShellText());
                String _mustachePath = nit.getMustachePath();
                String _mustacheText = nit.getMustacheText();
                FileWriteEntity _fileWriteEntity = new FileWriteEntity(_mustachePath, _mustacheText);
                fileWriteList.add(_fileWriteEntity);
                String _analysisShellPath = nit.getAnalysisShellPath();
                String _analysisShellText = nit.getAnalysisShellText();
                FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_analysisShellPath, _analysisShellText);
                fileWriteList.add(_fileWriteEntity_1);
                InputOutput.println((Object)fileWriteList.toString());
            };
            htemplate.getData().forEach(_function);
            entity.setHtmlTemplate(new Gson().toJson((Object)htemplate));
        }
        int _shellType = entity.getShellType();
        boolean _matched = false;
        int _ordinal = TaskEntity.ShellType.Shell.ordinal();
        if (Objects.equal((Object)_shellType, (Object)_ordinal)) {
            _matched = true;
            String _replace = UUID.randomUUID().toString().replace("-", "");
            String _plus = _replace + ".sh";
            File file = GetTaskDirectory.getScriptPath(entity, _plus);
            LOG.info("\u521b\u5efashell\u811a\u672c:{}", (Object)file.getAbsolutePath());
            entity.setShellPath(file.getAbsolutePath().trim());
            String _shellPath = entity.getShellPath();
            String _shellText = entity.getShellText();
            FileWriteEntity _fileWriteEntity = new FileWriteEntity(_shellPath, _shellText);
            fileWriteList.add(_fileWriteEntity);
        }
        if (!_matched) {
            int _ordinal_1 = TaskEntity.ShellType.BatchFile.ordinal();
            if (Objects.equal((Object)_shellType, (Object)_ordinal_1)) {
                _matched = true;
                String _replace_1 = UUID.randomUUID().toString().replace("-", "");
                String _plus_1 = _replace_1 + ".bat";
                File file_1 = GetTaskDirectory.getScriptPath(entity, _plus_1);
                LOG.info("\u521b\u5efaBAT\u811a\u672c:{}", (Object)file_1.getAbsolutePath());
                entity.setShellPath(file_1.getAbsolutePath().trim());
                String _shellPath_1 = entity.getShellPath();
                String _shellText_1 = entity.getShellText();
                FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_shellPath_1, _shellText_1);
                fileWriteList.add(_fileWriteEntity_1);
            }
        }
        if (!_matched) {
            int _ordinal_2 = TaskEntity.ShellType.Groovy.ordinal();
            if (Objects.equal((Object)_shellType, (Object)_ordinal_2)) {
                _matched = true;
                String _replace_2 = UUID.randomUUID().toString().replace("-", "");
                String _plus_2 = _replace_2 + ".groovy";
                File file_2 = GetTaskDirectory.getScriptPath(entity, _plus_2);
                LOG.info("\u521b\u5efaGroovy\u811a\u672c:{}", (Object)file_2.getAbsolutePath());
                entity.setShellPath(file_2.getAbsolutePath().trim());
                String _shellPath_2 = entity.getShellPath();
                String _shellText_2 = entity.getShellText();
                FileWriteEntity _fileWriteEntity_2 = new FileWriteEntity(_shellPath_2, _shellText_2);
                fileWriteList.add(_fileWriteEntity_2);
            }
        }
        if (!_matched) {
            int _ordinal_3 = TaskEntity.ShellType.JavaScript.ordinal();
            if (Objects.equal((Object)_shellType, (Object)_ordinal_3)) {
                _matched = true;
                String _replace_3 = UUID.randomUUID().toString().replace("-", "");
                String _plus_3 = _replace_3 + ".js";
                File file_3 = GetTaskDirectory.getScriptPath(entity, _plus_3);
                LOG.info("\u521b\u5efaJavascript\u811a\u672c:{}", (Object)file_3.getAbsolutePath());
                entity.setShellPath(file_3.getAbsolutePath().trim());
                String _shellPath_3 = entity.getShellPath();
                String _shellText_3 = entity.getShellText();
                FileWriteEntity _fileWriteEntity_3 = new FileWriteEntity(_shellPath_3, _shellText_3);
                fileWriteList.add(_fileWriteEntity_3);
            }
        }
        if (!_matched) {
            LOG.info("\u811a\u672c\u7c7b\u578b\u9519\u8bef:");
            return Response.status((int)500).build();
        }
        Integer _taskVersion = entity.getTaskVersion();
        int _plus_4 = _taskVersion + 1;
        entity.setTaskVersion(_plus_4);
        ICallback2 _function_1 = () -> fileWriteList;
        this.taskService.FileWrite(entity.getTaskDirectory(), entity.getTaskVersion(), (ICallback2<List<FileWriteEntity>>)_function_1);
        LOG.info("\u4fdd\u5b58\u4efb\u52a1:{}", (Object)entity.toString());
        int _saveTask = this.taskService.saveTask(entity);
        boolean bl2 = _greaterThan = _saveTask > 0;
        if (_greaterThan) {
            LOG.info("\u4fdd\u5b58\u4efb\u52a1\u6210\u529f");
            return Response.status((int)201).build();
        }
        return null;
    }

    @Override
    public Response runTask(String uuid) {
        TaskEntity entity = this.taskService.getOneTask(uuid);
        ArrayList<FileWriteEntity> fileWriteList = new ArrayList<FileWriteEntity>();
        if (this.iTask != null) {
            this.iTask.preTask(entity);
        }
        LOG.info("\u8fd0\u884c\u4efb\u52a1:{}", (Object)entity.getTaskName());
        TaskExtendColumnEntity _xifexpression = null;
        String _extendColumn = entity.getExtendColumn();
        boolean _tripleNotEquals = _extendColumn != null;
        _xifexpression = _tripleNotEquals ? (TaskExtendColumnEntity)new Gson().fromJson(entity.getExtendColumn(), TaskExtendColumnEntity.class) : null;
        TaskExtendColumnEntity extendColumn = _xifexpression;
        String _taskName = entity.getTaskName();
        Pair _mappedTo = Pair.of((Object)"taskName", (Object)_taskName);
        String _xifexpression_1 = null;
        _xifexpression_1 = extendColumn != null ? extendColumn.getProjectName() : "";
        Pair _mappedTo_1 = Pair.of((Object)"projectName", (Object)_xifexpression_1);
        String _property = System.getProperty("user.dir");
        Pair _mappedTo_2 = Pair.of((Object)"userDir", (Object)_property);
        String _taskDirectory = entity.getTaskDirectory();
        Pair _mappedTo_3 = Pair.of((Object)"workspace", (Object)_taskDirectory);
        Map<String, String> env = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3}));
        String _shellPath = entity.getShellPath();
        File shellFile = new File(_shellPath);
        boolean _exists = shellFile.exists();
        if (_exists) {
            int _shellType = entity.getShellType();
            boolean _matched = false;
            int _ordinal = TaskEntity.ShellType.Shell.ordinal();
            if (Objects.equal((Object)_shellType, (Object)_ordinal)) {
                _matched = true;
                ArrayList<String> results = new ArrayList<String>();
                LOG.info("\u8fd0\u884c\u4efb\u52a1\u811a\u672c:{}", (Object)shellFile.getAbsolutePath());
                entity.setStatus(TaskEntity.TaskStatus.IN_PROGRESS.ordinal());
                this.taskService.update(entity);
                ShellExecute.ShellCallback _function = it -> results.add(it);
                ShellExecute.start(entity.getTaskName(), _function, env, "bash", shellFile.getAbsolutePath());
                File file = GetTaskDirectory.getScriptResultPath(entity, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"execute_result", "txt"})), (CharSequence)"."));
                String _absolutePath = file.getAbsolutePath();
                String _join = IterableExtensions.join(results);
                FileWriteEntity fwentity = new FileWriteEntity(_absolutePath, _join);
                fileWriteList.add(fwentity);
                this.taskResultProcessing(results, extendColumn, entity, fileWriteList);
            }
            if (!_matched) {
                int _ordinal_1 = TaskEntity.ShellType.BatchFile.ordinal();
                if (Objects.equal((Object)_shellType, (Object)_ordinal_1)) {
                    _matched = true;
                    ArrayList<String> results_1 = new ArrayList<String>();
                    LOG.info("\u8fd0\u884c\u4efb\u52a1\u811a\u672c:{}", (Object)shellFile.getAbsolutePath());
                    entity.setStatus(TaskEntity.TaskStatus.IN_PROGRESS.ordinal());
                    this.taskService.update(entity);
                    ShellExecute.ShellCallback _function_1 = it -> results_1.add(it);
                    ShellExecute.start(entity.getTaskName(), _function_1, env, shellFile.getAbsolutePath());
                    File file_1 = GetTaskDirectory.getScriptResultPath(entity, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"execute_result", "txt"})), (CharSequence)"."));
                    String _absolutePath_1 = file_1.getAbsolutePath();
                    String _join_1 = IterableExtensions.join(results_1);
                    FileWriteEntity fwentity_1 = new FileWriteEntity(_absolutePath_1, _join_1);
                    fileWriteList.add(fwentity_1);
                    this.taskResultProcessing(results_1, extendColumn, entity, fileWriteList);
                }
            }
            if (!_matched) {
                int _ordinal_2 = TaskEntity.ShellType.Groovy.ordinal();
                if (Objects.equal((Object)_shellType, (Object)_ordinal_2)) {
                    _matched = true;
                }
            }
            if (!_matched) {
                int _ordinal_3 = TaskEntity.ShellType.JavaScript.ordinal();
                if (Objects.equal((Object)_shellType, (Object)_ordinal_3)) {
                    _matched = true;
                }
            }
            if (!_matched) {
                // empty if block
            }
        }
        if (this.iTask != null) {
            this.iTask.postTask(entity);
        }
        ICallback2 _function_2 = () -> fileWriteList;
        this.taskService.FileWrite(entity.getTaskDirectory(), entity.getTaskVersion(), (ICallback2<List<FileWriteEntity>>)_function_2);
        return Response.ok().build();
    }

    private void taskResultProcessing(ArrayList<String> results, TaskExtendColumnEntity extendColumn, TaskEntity entity, ArrayList<FileWriteEntity> fileWriteList) {
        LOG.info("\u9700\u8981\u5904\u7406\u8fd0\u884c\u7ed3\u679c\u884c\u6570:{}", (Object)((Object[])Conversions.unwrapArray(results, Object.class)).length);
        HashMap<String, String> jsEnv = new HashMap<String, String>();
        jsEnv.put("taskName", entity.getTaskName());
        jsEnv.put("taskId", entity.getTaskId());
        jsEnv.put("executeResultFilePath", GetTaskDirectory.getScriptResultPath(entity, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"execute_result", "txt"})), (CharSequence)".")).getAbsolutePath());
        HtmlTemplateEntity htemplate = (HtmlTemplateEntity)new Gson().fromJson(entity.getHtmlTemplate(), HtmlTemplateEntity.class);
        try {
            Consumer<HtmlTemplateEntity.DataEntity> _function = it -> {
                block8: {
                    try {
                        if (!FileTools.isEmpty((String)it.getAnalysisShellPath()) && !FileTools.isEmpty((String)it.getMustachePath())) {
                            jsEnv.put("analysisFilePath", (String)StringUtils.defaultIfEmpty((CharSequence)it.getAnalysisShellPath(), (CharSequence)""));
                            jsEnv.put("templateFilePath", (String)StringUtils.defaultIfEmpty((CharSequence)it.getMustachePath(), (CharSequence)""));
                            jsEnv.put("resultFilePath", (String)StringUtils.defaultIfEmpty((CharSequence)it.getResultPath(), (CharSequence)""));
                            jsEnv.put("name", (String)StringUtils.defaultIfEmpty((CharSequence)it.getName(), (CharSequence)""));
                            jsEnv.put("pname", (String)StringUtils.defaultIfEmpty((CharSequence)it.getPname(), (CharSequence)""));
                            String _analysisShellPath = it.getAnalysisShellPath();
                            File _file = new File(_analysisShellPath);
                            String analysisFile = FileUtils.readFileToString((File)_file, (String)"UTF-8");
                            boolean _isNotBlank = StringUtils.isNotBlank((CharSequence)analysisFile);
                            if (!_isNotBlank) break block8;
                            try (JsRhinoScript js = new JsRhinoScript();){
                                js.set("env", (Object)jsEnv);
                                js.set("log", (Object)LOG);
                                js.set("otherEnv", (Object)extendColumn);
                                String _taskDirectory = entity.getTaskDirectory();
                                GitFileHistory _gitFileHistory = new GitFileHistory(this.jgit, _taskDirectory);
                                js.set("fileHistory", (Object)_gitFileHistory);
                                StringBuffer buffer = new StringBuffer("function taomubox_template_entry(results){");
                                buffer.append(analysisFile);
                                buffer.append("return env;");
                                buffer.append("}");
                                js.loaderScript(buffer.toString());
                                Object _invoke = js.invoke("taomubox_template_entry", new Object[]{results});
                                Map resMap = (Map)_invoke;
                                LOG.info("\u89e3\u6790\u5668\u8fd4\u56de\u7ed3\u679c:{}", (Object)resMap.toString());
                                this.saveRunResult(entity, (HtmlTemplateEntity.DataEntity)it, resMap, (List<FileWriteEntity>)fileWriteList);
                                break block8;
                            }
                        }
                        String resultFileName = UUID.randomUUID().toString().replace("-", "");
                        String _pname = it.getPname();
                        File resFile = GetTaskDirectory.getResultPath(entity, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pname, resultFileName, "txt"})), (CharSequence)"."));
                        LOG.info("\u5c06\u7ed3\u679c\u4fdd\u5b58\u5230:{}", (Object)resFile.getAbsolutePath());
                        it.setResultPath(resFile.getAbsolutePath().trim());
                        String _resultPath = it.getResultPath();
                        String _join = IterableExtensions.join((Iterable)results);
                        FileWriteEntity _fileWriteEntity = new FileWriteEntity(_resultPath, _join);
                        fileWriteList.add(_fileWriteEntity);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            htemplate.getData().forEach(_function);
            Integer _taskVersion = entity.getTaskVersion();
            int _plus = _taskVersion + 1;
            entity.setTaskVersion(_plus);
            entity.setHtmlTemplate(new Gson().toJson((Object)htemplate));
            entity.setStatus(TaskEntity.TaskStatus.SUCCESS.ordinal());
            LOG.info("\u4efb\u52a1 {} \u66f4\u65b0\u6570\u636e\u5e93", (Object)entity.getTaskName());
            this.taskService.update(entity);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                entity.setStatus(TaskEntity.TaskStatus.FAIL.ordinal());
                entity.setExceptionInfo(ex.getMessage());
                this.taskService.update(entity);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void saveRunResult(TaskEntity entity, HtmlTemplateEntity.DataEntity dataEntity, Map<String, String> results, List<FileWriteEntity> fileWriteList) {
        try {
            LOG.info("\u4fdd\u5b58\u8fd0\u884c\u7ed3\u679c");
            if (dataEntity != null) {
                LOG.info("\u8fd0\u884c\u6a21\u7248\u5f15\u64ce\u751f\u6210\u683c\u5f0f\u5316\u6570\u636e");
                boolean _endsWith = dataEntity.getMustachePath().endsWith(".mustache");
                if (_endsWith) {
                    StringWriter writer = new StringWriter();
                    DefaultMustacheFactory mf = new DefaultMustacheFactory();
                    String _mustachePath = dataEntity.getMustachePath();
                    FileInputStream _fileInputStream = new FileInputStream(_mustachePath);
                    InputStreamReader reader = new InputStreamReader(_fileInputStream);
                    Mustache mustache = mf.compile((Reader)reader, dataEntity.getMustachePath());
                    mustache.execute((Writer)writer, results).flush();
                    String resultFileName = UUID.randomUUID().toString().replace("-", "");
                    String _pname = dataEntity.getPname();
                    File resFile = GetTaskDirectory.getResultPath(entity, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pname, resultFileName, "mustache", "txt"})), (CharSequence)"."));
                    LOG.info("\u5c06\u7ed3\u679c\u4fdd\u5b58\u5230:{}", (Object)resFile.getAbsolutePath());
                    dataEntity.setResultPath(resFile.getAbsolutePath().trim());
                    resFile.getAbsolutePath().trim();
                    String _string = writer.toString();
                    String content = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_string})));
                    String _absolutePath = resFile.getAbsolutePath();
                    FileWriteEntity _fileWriteEntity = new FileWriteEntity(_absolutePath, content);
                    fileWriteList.add(_fileWriteEntity);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Response exitTask(String uuid) {
        TaskEntity entity = this.taskService.getOneTask(uuid);
        LOG.info("\u7ed3\u675f\u4efb\u52a1:{}", (Object)entity.getTaskName());
        entity.setStatus(TaskEntity.TaskStatus.DONE.ordinal());
        this.taskService.update(entity);
        return Response.ok().build();
    }

    @Override
    public Response getTaskType() {
        LOG.info("\u83b7\u53d6\u4efb\u52a1\u7c7b\u578b");
        TaskEntity.TaskType[] _values = TaskEntity.TaskType.values();
        Pair _mappedTo = Pair.of((Object)"task_type", (Object)_values);
        Function<TaskEntity.TaskType, Integer> _function = it -> it.ordinal();
        List _collect = ((List)Conversions.doWrapArray((Object)TaskEntity.TaskType.values())).stream().map(_function).collect(Collectors.toList());
        Pair _mappedTo_1 = Pair.of((Object)"task_type_ordinal", _collect);
        TaskEntity.ShellType[] _values_1 = TaskEntity.ShellType.values();
        Pair _mappedTo_2 = Pair.of((Object)"shell_type", (Object)_values_1);
        Function<TaskEntity.ShellType, Integer> _function_1 = it -> it.ordinal();
        List _collect_1 = ((List)Conversions.doWrapArray((Object)TaskEntity.ShellType.values())).stream().map(_function_1).collect(Collectors.toList());
        Pair _mappedTo_3 = Pair.of((Object)"shell_type_ordinal", _collect_1);
        return Response.ok(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3}))).build();
    }

    @Override
    public Response getTaskResult(String uuid) {
        boolean _equals;
        TaskEntity entity = this.taskService.getOneTask(uuid);
        LOG.info("\u83b7\u53d6\u4efb\u52a1{}\u7ed3\u679c", (Object)entity.getTaskName());
        LOG.info("\u683c\u5f0f\u5316markdown\u6570\u636e");
        HtmlTemplateEntity htmlTemplate = (HtmlTemplateEntity)new Gson().fromJson(entity.getHtmlTemplate(), HtmlTemplateEntity.class);
        Consumer<HtmlTemplateEntity.DataEntity> _function = it -> {
            try {
                boolean _isNotBlank = StringUtils.isNotBlank((CharSequence)it.getResultPath());
                if (_isNotBlank) {
                    String result = MarkdownUtils.getHtml(it.getResultPath());
                    String _resultPath = it.getResultPath();
                    File _file = new File(_resultPath);
                    it.setMustacheText(FileUtils.readFileToString((File)_file, (String)"UTF-8"));
                    it.setResultText(result);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        htmlTemplate.getData().forEach(_function);
        int _status = entity.getStatus();
        int _ordinal = TaskEntity.TaskStatus.SUCCESS.ordinal();
        boolean bl = _equals = _status == _ordinal;
        if (_equals) {
            int _status_1 = entity.getStatus();
            List<HtmlTemplateEntity.DataEntity> _data = htmlTemplate.getData();
            TaskResultEntity<List<HtmlTemplateEntity.DataEntity>> _taskId = new TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>(_status_1, _data).taskId(entity.getTaskId());
            ResponseEntity<TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>> res = new ResponseEntity<TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>>(_taskId);
            return Response.ok(res.msg("\u83b7\u53d6\u4efb\u52a1\u7ed3\u679c")).build();
        }
        ResponseEntity res_1 = new ResponseEntity(Response.Status.NOT_FOUND);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(res_1).build();
    }

    @Override
    public Response getTaskList() {
        List<TaskEntity> entitys;
        List<TaskEntity> _converted_entitys = entitys = this.taskService.getTaskAll();
        LOG.info("\u83b7\u53d6\u4efb\u52a1\u5217\u8868:{}", (Object)((Object[])Conversions.unwrapArray(_converted_entitys, Object.class)).length);
        return Response.ok(entitys).build();
    }

    @Override
    public Response getTaskStatus(String uuid) {
        int _ordinal_3;
        boolean _equals_3;
        int _ordinal_2;
        boolean _equals_2;
        int _ordinal_1;
        boolean _equals_1;
        int _ordinal;
        boolean _equals;
        TaskEntity entity = this.taskService.getOneTask(uuid);
        int _status = entity.getStatus();
        boolean bl = _equals = _status == (_ordinal = TaskEntity.TaskStatus.SUCCESS.ordinal());
        if (_equals) {
            ResponseEntity res = new ResponseEntity(201);
            return Response.status((int)201).entity(res).build();
        }
        int _status_1 = entity.getStatus();
        boolean bl2 = _equals_1 = _status_1 == (_ordinal_1 = TaskEntity.TaskStatus.IN_PROGRESS.ordinal());
        if (_equals_1) {
            ResponseEntity res_1 = new ResponseEntity(100);
            return Response.status((int)100).entity(res_1).build();
        }
        int _status_2 = entity.getStatus();
        boolean bl3 = _equals_2 = _status_2 == (_ordinal_2 = TaskEntity.TaskStatus.FAIL.ordinal());
        if (_equals_2) {
            ResponseEntity res_2 = new ResponseEntity(500);
            return Response.status((int)500).entity(res_2).build();
        }
        int _status_3 = entity.getStatus();
        boolean bl4 = _equals_3 = _status_3 == (_ordinal_3 = TaskEntity.TaskStatus.WAIT.ordinal());
        if (_equals_3) {
            ResponseEntity res_3 = new ResponseEntity(202);
            return Response.status((int)202).entity(res_3).build();
        }
        ResponseEntity res_4 = new ResponseEntity(100);
        return Response.status((int)100).entity(res_4).build();
    }
}

