package cool.taomu.box.job.server.service;

import com.google.common.base.Objects;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.dao.TaskDao;
import cool.taomu.box.job.server.entity.TaskEntity;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback;
import cool.taomu.box.utils.inter.ICallback2;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class TaskService {
  @Inject
  private TaskDao dao;
  
  @Inject
  private JGitTools jgit;
  
  public void FileWrite(final String basePath, final int vserion, final ICallback2<List<FileWriteEntity>> call) {
    if ((call != null)) {
      final ArrayList<String> subPaths = new ArrayList<String>();
      final ArrayList<String> rmPaths = new ArrayList<String>();
      final Consumer<FileWriteEntity> _function = (FileWriteEntity it) -> {
        try {
          final String spath = it.getPath();
          FileWriteEntity.OperationType _type = it.getType();
          boolean _equals = Objects.equal(_type, FileWriteEntity.OperationType.ADD);
          if (_equals) {
            File _file = new File(spath);
            FileUtils.writeStringToFile(_file, it.getContent(), "UTF-8", false);
            String _trim = basePath.trim();
            String subPath = FileTools.getSubdirectory(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, File.separator))), spath);
            subPaths.add(subPath);
          } else {
            FileWriteEntity.OperationType _type_1 = it.getType();
            boolean _equals_1 = Objects.equal(_type_1, FileWriteEntity.OperationType.RM);
            if (_equals_1) {
              String _trim_1 = basePath.trim();
              String subPath_1 = FileTools.getSubdirectory(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, File.separator))), spath);
              rmPaths.add(subPath_1);
            }
          }
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      call.call().forEach(_function);
      this.jgit.setRepository(basePath);
      this.jgit.setAutoCommit(true);
      int _size = subPaths.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        final ICallback<AddCommand> _function_1 = (AddCommand it) -> {
          final Consumer<String> _function_2 = (String path) -> {
            it.addFilepattern(path);
          };
          subPaths.forEach(_function_2);
        };
        this.jgit.addAndCommit(IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList("add v", Integer.valueOf(vserion)))), _function_1);
      }
      int _size_1 = rmPaths.size();
      boolean _greaterThan_1 = (_size_1 > 0);
      if (_greaterThan_1) {
        final ICallback<RmCommand> _function_2 = (RmCommand it) -> {
          final Consumer<String> _function_3 = (String path) -> {
            it.addFilepattern(path);
          };
          rmPaths.forEach(_function_3);
        };
        this.jgit.rmAndCommit(IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList("rm v", Integer.valueOf(vserion)))), _function_2);
      }
    }
  }
  
  public TaskEntity getOneTask(final String taskId) {
    return this.dao.getOneTask(taskId);
  }
  
  public int deleteOneTask(final String taskId) {
    return this.dao.deleteOneTask(taskId);
  }
  
  public int update(final TaskEntity entity) {
    int _xifexpression = (int) 0;
    int _deleteOneTask = this.dao.deleteOneTask(entity.getTaskId());
    boolean _greaterThan = (_deleteOneTask > 0);
    if (_greaterThan) {
      _xifexpression = this.dao.saveTask(entity);
    }
    return _xifexpression;
  }
  
  public TaskEntity getOneTaskByTaskName(final String taskName) {
    return this.dao.getOneTaskByTaskName(taskName);
  }
  
  public int saveTask(final TaskEntity entity) {
    return this.dao.saveTask(entity);
  }
  
  public List<TaskEntity> getTaskAll() {
    return this.dao.getTaskAll();
  }
}
