package cool.taomu.box.job.server.controller.impl;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@SuppressWarnings("all")
public class AuthFilter implements ContainerRequestFilter {
  private static final Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
  
  @Inject
  @Named("taomubox.http.auth.value")
  private boolean isAuth;
  
  @Inject
  @Named("taomubox.http.auth.excludePath")
  private String excludePath;
  
  @Inject
  @Named("taomubox.http.auth.admin")
  private String admin;
  
  @Inject
  @Named("taomubox.http.auth.pwd")
  private String adminPwd;
  
  @Override
  public void filter(final ContainerRequestContext requestContext) throws IOException {
    AuthFilter.LOG.info("过滤规则");
    if ((this.isAuth && (!this.excludePath.equals("ALL")))) {
      final String path = requestContext.getUriInfo().getPath();
      String[] excludePathList = this.excludePath.split(",");
      final String[] _converted_excludePathList = (String[])excludePathList;
      final Function1<String, Boolean> _function = (String it) -> {
        Perl5Util p5 = new Perl5Util();
        return Boolean.valueOf(p5.match((("/" + it) + "/"), path));
      };
      String exPath = IterableExtensions.<String>findFirst(((Iterable<String>)Conversions.doWrapArray(_converted_excludePathList)), _function);
      if ((exPath != null)) {
        AuthFilter.LOG.info("访问限制排除路径:{}", path);
        return;
      }
      Subject subject = SecurityUtils.getSubject();
      Session session = subject.getSession();
      Object value = session.getAttribute("someKey");
      InputOutput.<Object>println(value);
      String authorizationHeader = requestContext.getHeaderString("Authorization");
      requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).build());
      return;
    }
  }
}
