/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.controller;

import cool.taomu.box.crypto.Base64;
import cool.taomu.box.crypto.Sha1;
import cool.taomu.box.job.server.dao.OAuth2UserDao;
import cool.taomu.box.job.server.entity.OAuth2UserEntity;
import cool.taomu.box.oltu.service.ServerService;
import cool.taomu.box.utils.DateTimeUtils;
import java.net.URI;
import java.util.Collections;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/server/oauth2")
public class OAuth2OwnerCode {
    private static Logger log = LoggerFactory.getLogger(OAuth2OwnerCode.class);
    @Inject
    private ServerService service;
    @Inject
    private OAuth2UserDao dao;

    @GET
    @Path(value="/owner/code")
    public Response sendCode(@Context HttpServletRequest request) {
        log.info("resource owner send code");
        try {
            ServerService.ICode _function = id -> {
                try {
                    long _dateTimeZoneTimestamp = DateTimeUtils.getDateTimeZoneTimestamp();
                    String code = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{id, _dateTimeZoneTimestamp})), (CharSequence)"");
                    byte[] _bytes = code.getBytes();
                    byte[] _encode = new Base64(_bytes).encode();
                    String resCode = new String(_encode, "UTF-8");
                    this.dao.updateByClientId(resCode, id);
                    return resCode;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            String uri = this.service.OwnerCode(request, _function);
            return Response.seeOther((URI)URI.create(uri)).build();
        }
        catch (Throwable _t) {
            if (_t instanceof OAuthSystemException) {
                OAuthSystemException e = (OAuthSystemException)_t;
                e.printStackTrace();
            } else if (_t instanceof OAuthProblemException) {
                OAuthProblemException e_1 = (OAuthProblemException)_t;
                e_1.printStackTrace();
            } else {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return null;
        }
    }

    @POST
    @Path(value="/authServer/token")
    public String getAccessToken(@Context HttpServletRequest request) throws OAuthProblemException, OAuthSystemException {
        log.info("\u8ba4\u8bc1\u670d\u52a1\u5668\uff0c\u63a5\u6536\u5230\u5ba2\u6237\u7684\u4ee4\u724c\u8bf7\u6c42 .... ");
        ServerService.IToken _function = (code, id, secret) -> {
            try {
                OAuth2UserEntity user = this.dao.selectByClientIdAndClientSecret(id, secret);
                String _code = user.getCode();
                byte[] _bytes = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_code, secret})), (CharSequence)"###").getBytes();
                byte[] _encode = new Sha1(_bytes).encode();
                String newCode = new String(_encode, "UTF-8");
                return user != null && newCode.equals(code);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        return this.service.getToken(request, _function);
    }
}

