/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public abstract class AbsThread extends Thread {
  private static final Logger LOG = LoggerFactory.getLogger(AbsThread.class);
  
  public abstract void execute();
  
  public abstract void clean();
  
  private volatile boolean running = true;
  
  @Override
  public void run() {
    while (this.running) {
      {
        this.execute();
        boolean _isInterrupted = Thread.currentThread().isInterrupted();
        if (_isInterrupted) {
          AbsThread.LOG.info("线程中断");
          this.clean();
          this.running = false;
        }
      }
    }
  }
  
  public void stopRunning() {
    AbsThread.LOG.info("线程结束...");
    this.running = false;
    this.interrupt();
    this.clean();
  }
}
