package cool.taomu.box.job.server.controller.impl;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@SuppressWarnings("all")
public class AuthFilter implements ContainerRequestFilter {
  private static final Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
  
  @Inject
  @Named("taomubox.http.auth.excludePath")
  private String excludePath;
  
  @Override
  public void filter(final ContainerRequestContext requestContext) throws IOException {
    System.out.println(this.excludePath);
    boolean _equals = this.excludePath.equals("ALL");
    boolean _not = (!_equals);
    if (_not) {
      final String path = requestContext.getUriInfo().getPath();
      String[] excludePathList = this.excludePath.split(",");
      final String[] _converted_excludePathList = (String[])excludePathList;
      final Function1<String, Boolean> _function = (String it) -> {
        return Boolean.valueOf(path.contains(it));
      };
      String exPath = IterableExtensions.<String>findFirst(((Iterable<String>)Conversions.doWrapArray(_converted_excludePathList)), _function);
      if ((exPath != null)) {
        AuthFilter.LOG.info("访问限制排除路径:{}", path);
        return;
      }
      String authorizationHeader = requestContext.getHeaderString("Authorization");
      requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).build());
      return;
    }
  }
}
