package cool.taomu.box.job.server.service;

import com.google.inject.Inject;
import cool.taomu.box.crypto.Base64;
import cool.taomu.box.job.server.dao.SecurityDao;
import cool.taomu.box.job.server.dao.UserDao;
import cool.taomu.box.job.server.dao.entity.SecurityDaoEntity;
import cool.taomu.box.job.server.dao.entity.UserDaoEntity;
import java.util.Collections;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class UserService {
  private static final Logger LOG = LoggerFactory.getLogger(UserService.class);
  
  @Inject
  private UserDao userDao;
  
  @Inject
  private SecurityDao shiroRealmDao;
  
  public UserDaoEntity getUserEntityByUsername(final String userName) {
    return this.userDao.getByUserName(userName);
  }
  
  public int saveUser(final UserDaoEntity entity) {
    entity.setClientId(UUID.randomUUID().toString().replace("-", ""));
    entity.setClientSecret(UUID.randomUUID().toString().replace("-", ""));
    String _clientSecret = entity.getClientSecret();
    String _string = UUID.randomUUID().toString();
    String _clientId = entity.getClientId();
    String acode = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("taomubox", _clientSecret, _string, _clientId)));
    byte[] _bytes = acode.getBytes();
    byte[] _encode = new Base64(_bytes).encode();
    String _string_1 = new String(_encode);
    entity.setAuthorizeCode(_string_1);
    return this.userDao.saveUesr(entity);
  }
  
  public void saveUserSecurity(final String userName, final SecurityDaoEntity srEntity) {
    String _uuid = srEntity.getUuid();
    boolean _tripleNotEquals = (_uuid != null);
    if (_tripleNotEquals) {
      SecurityDaoEntity entity = this.shiroRealmDao.getByUuId(srEntity.getUuid());
      UserDaoEntity uEntity = this.userDao.getByUserName(userName);
      if ((uEntity != null)) {
        int _saveSecurityUser = this.shiroRealmDao.saveSecurityUser(uEntity.getUuid(), entity.getUuid());
        boolean _greaterThan = (_saveSecurityUser > 0);
        if (_greaterThan) {
          UserService.LOG.info("保存{}用户权限成功", userName);
          return;
        }
      }
    } else {
      srEntity.setUuid(UUID.randomUUID().toString());
      this.shiroRealmDao.saveSecurity(srEntity);
      UserDaoEntity uEntity_1 = this.userDao.getByUserName(userName);
      if ((uEntity_1 != null)) {
        int _saveSecurityUser_1 = this.shiroRealmDao.saveSecurityUser(uEntity_1.getUuid(), srEntity.getUuid());
        boolean _greaterThan_1 = (_saveSecurityUser_1 > 0);
        if (_greaterThan_1) {
          UserService.LOG.info("保存{}用户权限成功", userName);
          return;
        }
      }
    }
    UserService.LOG.info("保存{}用户权限失败,用户不存在", userName);
  }
}
