/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.script.runtime;

import com.google.common.base.Objects;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.dao.entity.DataSourceDaoEntity;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
public class DataSource {
    private static final Logger LOG = LoggerFactory.getLogger(DataSource.class);
    private DataSourceDaoEntity dsDao;
    private String workspace;
    private JGitTools jgit;

    public DataSource(DataSourceDaoEntity dsDao, String workspace, JGitTools jgit) {
        this.dsDao = dsDao;
        this.jgit = jgit;
        this.workspace = workspace;
    }

    public Object pull(String args) {
        Object _switchResult = null;
        int _dataSourceType = this.dsDao.getDataSourceType();
        boolean _matched = false;
        int _ordinal = DataSourceDaoEntity.DataSourceTypeEnum.GIT.ordinal();
        if (Objects.equal((Object)_dataSourceType, (Object)_ordinal)) {
            _matched = true;
            Object _xblockexpression = null;
            String addr = this.dsDao.getAddress();
            int _lastIndexOf = addr.lastIndexOf("(");
            int _plus = _lastIndexOf + 1;
            String branch = addr.substring(_plus, addr.lastIndexOf(")"));
            branch = (String)StringUtils.defaultIfBlank((CharSequence)args, (CharSequence)branch);
            addr = addr.substring(0, addr.lastIndexOf("("));
            LOG.info("git\u6570\u636e\u6e90:{}->{}", (Object)addr, (Object)branch);
            boolean _startsWith = addr.startsWith("https");
            if (_startsWith) {
                String[] ainfo = this.dsDao.getAuthorizeInfo().split("/");
                String uname = ainfo[0];
                String upwd = ainfo[1];
                UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(uname, upwd);
                this.jgit.setCp((CredentialsProvider)_usernamePasswordCredentialsProvider);
            }
            this.jgit.setRepository(this.workspace, addr);
            this.jgit.setBranch(branch);
            Object _xifexpression = null;
            boolean _isReprositoryExists = this.jgit.isReprositoryExists();
            _xifexpression = _isReprositoryExists ? this.jgit.pull() : this.jgit.Clone();
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched) {
            int _ordinal_1 = DataSourceDaoEntity.DataSourceTypeEnum.FTP.ordinal();
            if (Objects.equal((Object)_dataSourceType, (Object)_ordinal_1)) {
                _matched = true;
                _switchResult = null;
            }
        }
        if (!_matched) {
            int _ordinal_2 = DataSourceDaoEntity.DataSourceTypeEnum.SFTP.ordinal();
            if (Objects.equal((Object)_dataSourceType, (Object)_ordinal_2)) {
                _matched = true;
                _switchResult = null;
            }
        }
        return _switchResult;
    }

    public Object push() {
        return null;
    }

    @Pure
    public DataSourceDaoEntity getDsDao() {
        return this.dsDao;
    }

    public void setDsDao(DataSourceDaoEntity dsDao) {
        this.dsDao = dsDao;
    }

    @Pure
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    @Pure
    public JGitTools getJgit() {
        return this.jgit;
    }

    public void setJgit(JGitTools jgit) {
        this.jgit = jgit;
    }
}

