/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.controller;

import cool.taomu.box.job.server.dao.OAuth2UserDao;
import cool.taomu.box.job.server.entity.OAuth2UserEntity;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Path("oauth2/user")
@SuppressWarnings("all")
public class OAuth2UserController {
  @Inject
  private OAuth2UserDao dao;
  
  @GET
  @Produces(MediaType.APPLICATION_JSON)
  public List<OAuth2UserEntity> all() {
    return this.dao.selectAll();
  }
  
  @GET
  @Path("{clientid}/{sercet}")
  @Produces(MediaType.APPLICATION_JSON)
  public OAuth2UserEntity getUser(@PathParam("clientid") final String clientid, @PathParam("sercet") final String sercet) {
    return this.dao.selectByClientIdAndClientSecret(clientid, sercet);
  }
  
  @POST
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_JSON)
  public String getUser(final OAuth2UserEntity entity) {
    String _xblockexpression = null;
    {
      entity.setUuid(UUID.randomUUID().toString());
      this.dao.insert(entity.getUuid(), entity.getClientId(), entity.getClientSecret(), entity.getCallbackUrl());
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
}
