package cool.taomu.box.job.server.controller.entity;

import javax.ws.rs.core.Response;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class ResponseEntity<T extends Object> {
  private int status = 200;
  
  private String msg = "";
  
  private T results;
  
  public ResponseEntity(final int status) {
    this.status = status;
  }
  
  public ResponseEntity(final Response.Status status) {
    this.status = status.getStatusCode();
    this.msg = status.getReasonPhrase();
  }
  
  public ResponseEntity<T> results(final T results) {
    this.results = results;
    return this;
  }
  
  public ResponseEntity<T> status(final int status) {
    this.status = status;
    return this;
  }
  
  public ResponseEntity<T> msg(final String msg) {
    this.msg = msg;
    return this;
  }
  
  @Pure
  public int getStatus() {
    return this.status;
  }
  
  public void setStatus(final int status) {
    this.status = status;
  }
  
  @Pure
  public String getMsg() {
    return this.msg;
  }
  
  public void setMsg(final String msg) {
    this.msg = msg;
  }
  
  @Pure
  public T getResults() {
    return this.results;
  }
  
  public void setResults(final T results) {
    this.results = results;
  }
}
