/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.entity;

import java.io.Serializable;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class OAuth2UserEntity implements Serializable {
  private String uuid;
  
  private String clientId;
  
  private String clientSecret;
  
  private String callbackUrl;
  
  private String code;
  
  public String getCode() {
    return this.code;
  }
  
  public String getUuid() {
    return this.uuid;
  }
  
  public void setUuid(final String uuid) {
    this.uuid = uuid;
  }
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Pure
  public String getClientSecret() {
    return this.clientSecret;
  }
  
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }
  
  @Pure
  public String getCallbackUrl() {
    return this.callbackUrl;
  }
  
  public void setCallbackUrl(final String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }
  
  public void setCode(final String code) {
    this.code = code;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("uuid", this.uuid);
    b.add("clientId", this.clientId);
    b.add("clientSecret", this.clientSecret);
    b.add("callbackUrl", this.callbackUrl);
    b.add("code", this.code);
    return b.toString();
  }
}
