/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.utils;

import java.util.List;
import java.util.function.Consumer;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class ChineseToPinyin {
  public static String toPinyin(final String chinese) {
    final HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
    format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
    format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    final StringBuffer buffer = new StringBuffer();
    char[] chars = chinese.toCharArray();
    final char[] _converted_chars = (char[])chars;
    final Consumer<Character> _function = (Character it) -> {
      boolean _isWhitespace = Character.isWhitespace((it).charValue());
      boolean _not = (!_isWhitespace);
      if (_not) {
        if ((((it).charValue() >= '一') && ((it).charValue() <= '龥'))) {
          try {
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((it).charValue(), format);
            buffer.append(pinyinArray[0]);
          } catch (final Throwable _t) {
            if (_t instanceof BadHanyuPinyinOutputFormatCombination) {
              final BadHanyuPinyinOutputFormatCombination e = (BadHanyuPinyinOutputFormatCombination)_t;
              e.printStackTrace();
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        } else {
          buffer.append(it);
        }
      }
    };
    ((List<Character>)Conversions.doWrapArray(_converted_chars)).forEach(_function);
    return buffer.toString();
  }
}
