package cool.taomu.box.job.server.utils;

import java.sql.SQLException;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * org.h2.Driver
 */
@SuppressWarnings("all")
public class H2Start implements Runnable {
  private static final Logger LOG = LoggerFactory.getLogger(H2Start.class);
  
  private int port = 9092;
  
  public H2Start() {
  }
  
  public H2Start(final int port) {
    this.port = port;
  }
  
  @Override
  public void run() {
    try {
      H2Start.LOG.info(("启动H2服务器 port" + Integer.valueOf(this.port)));
      String _valueOf = String.valueOf(this.port);
      Server.createTcpServer(new String[] { "-tcp", "-tcpPort", _valueOf, "-tcpAllowOthers", "-ifNotExists" }).start();
    } catch (final Throwable _t) {
      if (_t instanceof SQLException) {
        final SQLException ex = (SQLException)_t;
        H2Start.LOG.info(ex.getMessage(), ex);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
