/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.config;

import cool.taomu.box.ioc.ann.Binder;
import cool.taomu.box.ioc.ann.Binders;
import cool.taomu.box.netty.inter.IServerConfigure;
import cool.taomu.box.netty.mqtt.NettyMqttHandler;
import cool.taomu.box.netty.pipline.MqttConfigure;
import io.netty.channel.ChannelInboundHandler;

@Binders(properties = "server.yml", value = { @Binder(to = NettyMqttHandler.class, bind = ChannelInboundHandler.class), @Binder(to = MqttConfigure.class, bind = IServerConfigure.class) })
@SuppressWarnings("all")
public class MqttServerConfig {
}
