package cool.taomu.box.job.server.service;

import com.google.common.base.Objects;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.dao.TaskDao;
import cool.taomu.box.job.server.dao.TaskDataProcessingDao;
import cool.taomu.box.job.server.dao.TaskDataSourceDao;
import cool.taomu.box.job.server.dao.TaskResultDao;
import cool.taomu.box.job.server.dao.entity.DataProcessingDaoEntity;
import cool.taomu.box.job.server.dao.entity.DataSourceDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskResultDaoEntity;
import cool.taomu.box.job.server.utils.ChineseToPinyin;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback;
import cool.taomu.box.utils.inter.ICallback2;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TaskService {
  private static final Logger LOG = LoggerFactory.getLogger(TaskService.class);
  
  @Inject
  private TaskDao dao;
  
  @Inject
  private TaskDataSourceDao dsDao;
  
  @Inject
  private TaskDataProcessingDao dpDao;
  
  @Inject
  private TaskResultDao trDao;
  
  @Inject
  private TaskRepositoryService trservice;
  
  @Inject
  private JGitTools jgit;
  
  private String basePath = System.getProperty("user.dir");
  
  public DataSourceDaoEntity getOneDataSourceByUuid(final String uuid) {
    return this.dsDao.getOneByUuId(uuid);
  }
  
  public DataProcessingDaoEntity getOneDataProcessingByUuid(final String uuid) {
    return this.dpDao.getOneByUuId(uuid);
  }
  
  public List<TaskResultDaoEntity> getAllByTaskId(final String taskId) {
    return this.trDao.getAllByTaskId(taskId);
  }
  
  public int createWorkspace(final TaskDaoEntity taskEntity, final List<String> ignores) {
    int _xifexpression = (int) 0;
    boolean _isBlank = StringUtils.isBlank(taskEntity.getTaskDirectory());
    if (_isBlank) {
      int _xblockexpression = (int) 0;
      {
        String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(this.basePath, "workspace")), File.separator);
        File ws = new File(_join);
        ws.mkdirs();
        String taskNamePinyin = ChineseToPinyin.toPinyin(taskEntity.getTaskName());
        TaskService.LOG.info("任务名:{} 转为拼音:{}", taskEntity.getTaskName(), taskNamePinyin);
        String _absolutePath = ws.getAbsolutePath();
        String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath, taskNamePinyin)), File.separator);
        File cdir = new File(_join_1);
        cdir.mkdirs();
        taskEntity.setTaskDirectory(cdir.getAbsolutePath().replace(ws.getAbsolutePath(), ""));
        String _absolutePath_1 = cdir.getAbsolutePath();
        this.trservice.repositoryPath(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath_1)), File.separator));
        this.trservice.init(ignores);
        GetTaskDirectory.getDatasource(cdir.getAbsolutePath(), null);
        GetTaskDirectory.getDataprocessing(cdir.getAbsolutePath(), null);
        GetTaskDirectory.getDataresult(cdir.getAbsolutePath(), null);
        _xblockexpression = this.update(taskEntity);
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  public void FileWrite(final String basePath, final int vserion, final ICallback2<List<FileWriteEntity>> call) {
    if ((call != null)) {
      final ArrayList<String> subPaths = new ArrayList<String>();
      final ArrayList<String> rmPaths = new ArrayList<String>();
      final Consumer<FileWriteEntity> _function = (FileWriteEntity it) -> {
        try {
          final String spath = it.getPath();
          FileWriteEntity.OperationType _type = it.getType();
          boolean _equals = Objects.equal(_type, FileWriteEntity.OperationType.ADD);
          if (_equals) {
            TaskService.LOG.info("添加文件:{}", spath);
            File _file = new File(spath);
            FileUtils.writeStringToFile(_file, it.getContent().trim(), "UTF-8", false);
            String _trim = basePath.trim();
            String subPath = FileTools.getSubdirectory(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim, File.separator))), spath, "/");
            subPaths.add(subPath);
          } else {
            FileWriteEntity.OperationType _type_1 = it.getType();
            boolean _equals_1 = Objects.equal(_type_1, FileWriteEntity.OperationType.RM);
            if (_equals_1) {
              TaskService.LOG.info("删除文件:{}", spath);
              String _trim_1 = basePath.trim();
              String subPath_1 = FileTools.getSubdirectory(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_trim_1, File.separator))), spath, "/");
              rmPaths.add(subPath_1);
            }
          }
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      call.call().forEach(_function);
      int _size = subPaths.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        this.jgit.setRepository(basePath);
        boolean _isReprositoryExists = this.jgit.isReprositoryExists();
        boolean _not = (!_isReprositoryExists);
        if (_not) {
          this.jgit.init();
        }
        this.jgit.setAutoCommit(true);
        TaskService.LOG.info("向本地库添加文件 {} 份", Integer.valueOf(subPaths.size()));
        String _join = IterableExtensions.join(subPaths, "\n");
        final ICallback<AddCommand> _function_1 = (AddCommand it) -> {
          final Consumer<String> _function_2 = (String path) -> {
            it.addFilepattern(path);
          };
          subPaths.forEach(_function_2);
        };
        this.jgit.addAndCommit(IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList("add v", Integer.valueOf(vserion), "\n", _join))), _function_1);
      }
      int _size_1 = rmPaths.size();
      boolean _greaterThan_1 = (_size_1 > 0);
      if (_greaterThan_1) {
        this.jgit.setRepository(basePath);
        boolean _isReprositoryExists_1 = this.jgit.isReprositoryExists();
        boolean _not_1 = (!_isReprositoryExists_1);
        if (_not_1) {
          this.jgit.init();
        }
        this.jgit.setAutoCommit(true);
        TaskService.LOG.info("向本地库删除文件 {} 份", Integer.valueOf(rmPaths.size()));
        String _join_1 = IterableExtensions.join(rmPaths, "\n");
        final ICallback<RmCommand> _function_2 = (RmCommand it) -> {
          final Consumer<String> _function_3 = (String path) -> {
            it.addFilepattern(path);
          };
          rmPaths.forEach(_function_3);
        };
        this.jgit.rmAndCommit(IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList("rm v", Integer.valueOf(vserion), "\n", _join_1))), _function_2);
      }
    }
  }
  
  public TaskDaoEntity getOneTask(final String taskId) {
    return this.dao.getOneTask(taskId);
  }
  
  public int deleteOneTask(final String taskId) {
    return this.dao.deleteOneTask(taskId);
  }
  
  public int update(final TaskDaoEntity entity) {
    int _xifexpression = (int) 0;
    int _deleteOneTask = this.dao.deleteOneTask(entity.getTaskId());
    boolean _greaterThan = (_deleteOneTask > 0);
    if (_greaterThan) {
      _xifexpression = this.dao.saveTask(entity);
    } else {
      _xifexpression = this.dao.saveTask(entity);
    }
    return _xifexpression;
  }
  
  public TaskDaoEntity getOneTaskByTaskName(final String taskName) {
    return this.dao.getOneTaskByTaskName(taskName);
  }
  
  public int saveTask(final TaskDaoEntity entity) {
    return this.dao.saveTask(entity);
  }
  
  public int saveTaskDataSource(final DataSourceDaoEntity entity) {
    return this.dsDao.saveDataSource(entity);
  }
  
  public int updateTaskDataSource(final DataSourceDaoEntity entity) {
    int _xifexpression = (int) 0;
    int _deleteOneDataSource = this.dsDao.deleteOneDataSource(entity.getUuid());
    boolean _greaterThan = (_deleteOneDataSource > 0);
    if (_greaterThan) {
      _xifexpression = this.dsDao.saveDataSource(entity);
    }
    return _xifexpression;
  }
  
  public List<TaskDaoEntity> getTaskAll() {
    return this.dao.getTaskAll();
  }
  
  public List<? extends Pair<String, ?>> getTaskTypeList() {
    DataSourceDaoEntity.DataSourceTypeEnum[] _values = DataSourceDaoEntity.DataSourceTypeEnum.values();
    Pair<String, DataSourceDaoEntity.DataSourceTypeEnum[]> _mappedTo = Pair.<String, DataSourceDaoEntity.DataSourceTypeEnum[]>of("data_source_type", _values);
    final Function<DataSourceDaoEntity.DataSourceTypeEnum, Integer> _function = (DataSourceDaoEntity.DataSourceTypeEnum it) -> {
      return Integer.valueOf(it.ordinal());
    };
    List<Integer> _collect = ((List<DataSourceDaoEntity.DataSourceTypeEnum>)Conversions.doWrapArray(DataSourceDaoEntity.DataSourceTypeEnum.values())).stream().<Integer>map(_function).collect(Collectors.<Integer>toList());
    Pair<String, List<Integer>> _mappedTo_1 = Pair.<String, List<Integer>>of("data_source_type_value", _collect);
    DataProcessingDaoEntity.DataProcessingTypeEnum[] _values_1 = DataProcessingDaoEntity.DataProcessingTypeEnum.values();
    Pair<String, DataProcessingDaoEntity.DataProcessingTypeEnum[]> _mappedTo_2 = Pair.<String, DataProcessingDaoEntity.DataProcessingTypeEnum[]>of("data_processing_type", _values_1);
    final Function<DataProcessingDaoEntity.DataProcessingTypeEnum, Integer> _function_1 = (DataProcessingDaoEntity.DataProcessingTypeEnum it) -> {
      return Integer.valueOf(it.ordinal());
    };
    List<Integer> _collect_1 = ((List<DataProcessingDaoEntity.DataProcessingTypeEnum>)Conversions.doWrapArray(DataProcessingDaoEntity.DataProcessingTypeEnum.values())).stream().<Integer>map(_function_1).collect(Collectors.<Integer>toList());
    Pair<String, List<Integer>> _mappedTo_3 = Pair.<String, List<Integer>>of("data_processing_type_value", _collect_1);
    return Collections.<Pair<String, ?>>unmodifiableList(CollectionLiterals.<Pair<String, ?>>newArrayList(_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3));
  }
  
  public int saveTaskDataProcessing(final DataProcessingDaoEntity entity) {
    return this.dpDao.saveDataSource(entity);
  }
  
  public int deleteTaskDataProcessing(final String uuid) {
    return this.dpDao.deleteOneDataProcessing(uuid);
  }
  
  public int deleteDataSource(final String uuid) {
    return this.dsDao.deleteOneDataSource(uuid);
  }
  
  public int updateTaskDataProcessing(final DataProcessingDaoEntity entity) {
    int _xifexpression = (int) 0;
    int _deleteOneDataProcessing = this.dpDao.deleteOneDataProcessing(entity.getUuid());
    boolean _greaterThan = (_deleteOneDataProcessing > 0);
    if (_greaterThan) {
      _xifexpression = this.dpDao.saveDataSource(entity);
    }
    return _xifexpression;
  }
  
  public int saveTaskResult(final TaskResultDaoEntity entity) {
    return this.trDao.saveDataSource(entity);
  }
  
  public int updateTaskResult(final TaskResultDaoEntity entity) {
    int _xifexpression = (int) 0;
    int _deleteOneTaskResultByUuid = this.trDao.deleteOneTaskResultByUuid(entity.getUuid());
    boolean _greaterThan = (_deleteOneTaskResultByUuid > 0);
    if (_greaterThan) {
      _xifexpression = this.trDao.saveDataSource(entity);
    } else {
      _xifexpression = this.trDao.saveDataSource(entity);
    }
    return _xifexpression;
  }
  
  public int deleteTaskResultByTaskId(final String taskId) {
    int _xblockexpression = (int) 0;
    {
      List<TaskResultDaoEntity> results = this.trDao.getAllByTaskId(taskId);
      final ArrayList<FileWriteEntity> fileWriteList = new ArrayList<FileWriteEntity>();
      final Consumer<TaskResultDaoEntity> _function = (TaskResultDaoEntity it) -> {
        String _analyzeAndExtractFilePath = it.getAnalyzeAndExtractFilePath();
        FileWriteEntity _fileWriteEntity = new FileWriteEntity(_analyzeAndExtractFilePath, FileWriteEntity.OperationType.RM);
        fileWriteList.add(_fileWriteEntity);
        String _formatScriptFilePath = it.getFormatScriptFilePath();
        FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_formatScriptFilePath, FileWriteEntity.OperationType.RM);
        fileWriteList.add(_fileWriteEntity_1);
      };
      results.forEach(_function);
      int _xifexpression = (int) 0;
      int _deleteOneTaskResultByTaskId = this.trDao.deleteOneTaskResultByTaskId(taskId);
      boolean _greaterThan = (_deleteOneTaskResultByTaskId > 0);
      if (_greaterThan) {
        int _xblockexpression_1 = (int) 0;
        {
          TaskDaoEntity task = this.getOneTask(taskId);
          Integer _taskVersion = task.getTaskVersion();
          int _plus = ((_taskVersion).intValue() + 1);
          task.setTaskVersion(Integer.valueOf(_plus));
          final String pyTaskName = ChineseToPinyin.toPinyin(task.getTaskName());
          final ICallback2<List<FileWriteEntity>> _function_1 = () -> {
            return fileWriteList;
          };
          this.FileWrite(GetTaskDirectory.getWorkspace(pyTaskName), (task.getTaskVersion()).intValue(), _function_1);
          _xblockexpression_1 = this.update(task);
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
