package cool.taomu.box.job.server.utils;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

@SuppressWarnings("all")
public class CsvUtils {
  private String filePath;
  
  public CsvUtils(final String filePath) {
    this.filePath = filePath;
  }
  
  private List<List<String>> csvRes = new ArrayList<List<String>>();
  
  public void append(final String... args) {
    this.csvRes.add(Arrays.<String>asList(args));
  }
  
  public void write() {
    try {
      int _size = this.csvRes.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        try (CSVWriter csvWriter = new Function0<CSVWriter>() {
          @Override
          public CSVWriter apply() {
            try {
              FileWriter _fileWriter = new FileWriter(CsvUtils.this.filePath);
              return new CSVWriter(_fileWriter);
            } catch (Throwable _e) {
              throw Exceptions.sneakyThrow(_e);
            }
          }
        }.apply()) {
          final Function<List<String>, String[]> _function = (List<String> list) -> {
            return list.<String>toArray(new String[0]);
          };
          List<String[]> resultsStrArray = this.csvRes.stream().<String[]>map(_function).collect(Collectors.<String[]>toList());
          csvWriter.writeAll(resultsStrArray);
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public List<String[]> read() {
    try {
      try (CSVReader csvRead = new Function0<CSVReader>() {
        @Override
        public CSVReader apply() {
          try {
            FileReader _fileReader = new FileReader(CsvUtils.this.filePath);
            return new CSVReader(_fileReader);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        return csvRead.readAll();
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
