package cool.taomu.box.job.server.dao.entity;

import cool.taomu.box.mybatis.plus.ann.Column;
import cool.taomu.box.mybatis.plus.ann.Table;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@Table("TAOMUBOX_JOB_DATA_PROCESSING")
@SuppressWarnings("all")
public class DataProcessingDaoEntity {
  public enum DataProcessingTypeEnum {
    NONE,
    
    Shell,
    
    Bat,
    
    SSH_SHELL,
    
    Groovy;
  }
  
  @Column(value = "uuid")
  private String uuid;
  
  @Column(value = "name")
  private String name;
  
  @Column(value = "DATA_PROCESSING_TYPE")
  private int dataProcessingType = DataProcessingDaoEntity.DataProcessingTypeEnum.NONE.ordinal();
  
  @Column(value = "EXTEND_COLUMN")
  private String extendColumn;
  
  @Column(value = "script_file_path")
  private String scriptFilePath;
  
  @Pure
  public String getUuid() {
    return this.uuid;
  }
  
  public void setUuid(final String uuid) {
    this.uuid = uuid;
  }
  
  @Pure
  public String getName() {
    return this.name;
  }
  
  public void setName(final String name) {
    this.name = name;
  }
  
  @Pure
  public int getDataProcessingType() {
    return this.dataProcessingType;
  }
  
  public void setDataProcessingType(final int dataProcessingType) {
    this.dataProcessingType = dataProcessingType;
  }
  
  @Pure
  public String getExtendColumn() {
    return this.extendColumn;
  }
  
  public void setExtendColumn(final String extendColumn) {
    this.extendColumn = extendColumn;
  }
  
  @Pure
  public String getScriptFilePath() {
    return this.scriptFilePath;
  }
  
  public void setScriptFilePath(final String scriptFilePath) {
    this.scriptFilePath = scriptFilePath;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("uuid", this.uuid);
    b.add("name", this.name);
    b.add("dataProcessingType", this.dataProcessingType);
    b.add("extendColumn", this.extendColumn);
    b.add("scriptFilePath", this.scriptFilePath);
    return b.toString();
  }
}
