/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.controller;

import cool.taomu.box.job.server.dao.TaskDao;
import cool.taomu.box.job.server.service.UserService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="job")
public class IndexController {
    private static final Logger LOG = LoggerFactory.getLogger(IndexController.class);
    @Inject
    private TaskDao dao;
    @Inject
    private UserService uservice;
    @Inject
    @Named(value="taomubox.title")
    private String title;
    @Inject
    @Named(value="taomubox.http.pathSpec")
    private String pathSpec = "";
    @Inject
    @Named(value="taomubox.http.auth.value")
    private boolean isAuth;

    @GET
    @Path(value="/{page}")
    @ErrorTemplate(name="/error.ftl")
    @Template(name="/main.ftl")
    @Produces(value={"text/html"})
    public Map<String, String> page(@PathParam(value="page") String page, @Context HttpServletRequest request) {
        try {
            HashMap<String, String> pcmap = new HashMap<String, String>();
            pcmap.put("title", this.title);
            pcmap.put("pathSpec", this.pathSpec.trim());
            HttpSession session = request.getSession(false);
            StringBuffer buf = new StringBuffer("<script>");
            buf.append("var pathSpec='");
            buf.append(this.pathSpec);
            buf.append("';</script>");
            if (session != null && session.getAttribute("user_login_tag") != null || !this.isAuth) {
                File _file = new File("./template/" + page + ".html");
                buf.append(FileUtils.readFileToString((File)_file, (String)"UTF-8"));
                pcmap.put("content", buf.toString());
                File _file_1 = new File("./template/menu.html");
                pcmap.put("menu", FileUtils.readFileToString((File)_file_1, (String)"UTF-8"));
                File _file_2 = new File("./template/navbar.html");
                pcmap.put("navbar", FileUtils.readFileToString((File)_file_2, (String)"UTF-8"));
            } else {
                File _file_3 = new File("./template/login.html");
                buf.append(FileUtils.readFileToString((File)_file_3, (String)"UTF-8"));
                pcmap.put("content", buf.toString());
                pcmap.put("menu", "");
                File _file_4 = new File("./template/navbar_login.html");
                pcmap.put("navbar", FileUtils.readFileToString((File)_file_4, (String)"UTF-8"));
            }
            return pcmap;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

