/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.service;

import com.google.inject.Inject;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.TaomuboxConfigure;
import cool.taomu.box.utils.inter.ICallback;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class TaskRepositoryService {
    @Inject
    private JGitTools jgit;
    private final String basePath = TaomuboxConfigure.basePath;
    private String repositoryPath = "";

    public String repositoryPath(String path) {
        String _xifexpression = null;
        boolean _contains = path.contains(this.basePath);
        _xifexpression = _contains ? path : IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.basePath, path})), (CharSequence)File.separator);
        this.repositoryPath = _xifexpression.trim();
        return this.repositoryPath;
    }

    public void init(List<String> ignoreFiles) {
        try {
            this.jgit.setRepository(this.repositoryPath);
            this.jgit.init();
            if (ignoreFiles != null && ignoreFiles.size() > 0) {
                String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.repositoryPath, ".gitignore"})), (CharSequence)File.separator);
                File _file = new File(_join);
                FileUtils.writeLines((File)_file, (String)"UTF-8", ignoreFiles);
                ICallback _function = it -> it.addFilepattern(".gitignore");
                this.jgit.addAndCommit("add .gitignore file", _function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void add(List<FileEntity> fileList) {
        this.add("add file:", fileList);
    }

    public void add(String msg, List<FileEntity> fileList) {
        if (fileList != null && fileList.size() > 0) {
            boolean _not;
            ArrayList filePaths = new ArrayList();
            Consumer<FileEntity> _function = it -> {
                try {
                    String fileDir = this.repositoryPath;
                    boolean _isNotBlank = StringUtils.isNotBlank((CharSequence)((FileEntity)it).path);
                    if (_isNotBlank) {
                        String _path = it.getPath();
                        String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{fileDir, _path})), (CharSequence)File.separator);
                        new File(_join).mkdirs();
                    }
                    String _path_1 = it.getPath();
                    String _join_1 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{((FileEntity)it).name, ((FileEntity)it).suffix})), (CharSequence)"");
                    String _join_2 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{fileDir, _path_1, _join_1})), (CharSequence)File.separator);
                    File file = new File(_join_2);
                    FileUtils.writeLines((File)file, (String)"UTF-8", (Collection)((FileEntity)it).content);
                    filePaths.add(FileTools.getSubdirectory((String)(fileDir + File.separator), (String)file.getAbsolutePath(), (String)"/"));
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            fileList.forEach(_function);
            this.jgit.setRepository(this.repositoryPath);
            boolean _isAutoCommit = this.jgit.isAutoCommit();
            boolean bl = _not = !_isAutoCommit;
            if (_not) {
                this.jgit.setAutoCommit(true);
            }
            String _join = IterableExtensions.join(filePaths, (CharSequence)"\n");
            ICallback _function_1 = it -> {
                Consumer<String> _function_2 = fpath -> it.addFilepattern(fpath);
                filePaths.forEach(_function_2);
            };
            this.jgit.addAndCommit(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{msg, _join})), (CharSequence)"\n"), _function_1);
        }
    }

    public void rm(List<FileEntity> fileList) {
        this.rm("rm file:", fileList);
    }

    public void rm(String msg, List<FileEntity> fileList) {
        boolean _not;
        ArrayList filePaths = new ArrayList();
        Consumer<FileEntity> _function = it -> {
            String fileDir = this.repositoryPath;
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{((FileEntity)it).name, ((FileEntity)it).suffix})), (CharSequence)"");
            String _join_1 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{fileDir, ((FileEntity)it).path, _join})), (CharSequence)File.separator);
            File file = new File(_join_1);
            filePaths.add(FileTools.getSubdirectory((String)(fileDir + File.separator), (String)file.getAbsolutePath(), (String)"/"));
        };
        fileList.forEach(_function);
        this.jgit.setRepository(this.repositoryPath);
        boolean _isAutoCommit = this.jgit.isAutoCommit();
        boolean bl = _not = !_isAutoCommit;
        if (_not) {
            this.jgit.setAutoCommit(true);
        }
        String _join = IterableExtensions.join(filePaths, (CharSequence)"\n");
        ICallback _function_1 = it -> {
            Consumer<String> _function_2 = fpath -> it.addFilepattern(fpath);
            filePaths.forEach(_function_2);
        };
        this.jgit.rmAndCommit(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{msg, _join})), (CharSequence)"\n"), _function_1);
    }

    @Accessors
    @ToString
    public static class FileEntity {
        private String name;
        private List<String> content = new ArrayList<String>();
        private String path = "";
        private String suffix = ".txt";

        public FileEntity(String name) {
            this.name = name;
        }

        public FileEntity(String name, String suffix) {
            this.name = name;
            this.suffix = suffix;
        }

        public FileEntity content(List<String> content) {
            this.content.addAll(content);
            return this;
        }

        public FileEntity path(String path) {
            FileEntity _xblockexpression = null;
            this.path = path;
            _xblockexpression = this;
            return _xblockexpression;
        }

        @Pure
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Pure
        public List<String> getContent() {
            return this.content;
        }

        public void setContent(List<String> content) {
            this.content = content;
        }

        @Pure
        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Pure
        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            b.add("content", this.content);
            b.add("path", (Object)this.path);
            b.add("suffix", (Object)this.suffix);
            return b.toString();
        }
    }
}

