package cool.taomu.box.job.server.controller.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class FileWriteEntity {
  public enum OperationType {
    ADD,
    
    RM;
  }
  
  private String path;
  
  private String content;
  
  private FileWriteEntity.OperationType type = FileWriteEntity.OperationType.ADD;
  
  /**
   * String path
   * String content
   */
  public FileWriteEntity(final String path, final String content) {
    this.path = path;
    this.content = content;
  }
  
  public FileWriteEntity(final String path, final FileWriteEntity.OperationType type) {
    this.path = path;
    this.type = type;
  }
  
  /**
   * path String
   * content String
   * type OperationType
   */
  public FileWriteEntity(final String path, final String content, final FileWriteEntity.OperationType type) {
    this.path = path;
    this.content = content;
    this.type = type;
  }
  
  @Pure
  public String getPath() {
    return this.path;
  }
  
  public void setPath(final String path) {
    this.path = path;
  }
  
  @Pure
  public String getContent() {
    return this.content;
  }
  
  public void setContent(final String content) {
    this.content = content;
  }
  
  @Pure
  public FileWriteEntity.OperationType getType() {
    return this.type;
  }
  
  public void setType(final FileWriteEntity.OperationType type) {
    this.type = type;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("path", this.path);
    b.add("content", this.content);
    b.add("type", this.type);
    return b.toString();
  }
}
