/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.entity;

import cool.taomu.box.mybatis.plus.ann.Column;
import cool.taomu.box.mybatis.plus.ann.Table;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@Table("TAOMUBOX_MQTT_USER")
@SuppressWarnings("all")
public class MqttUserEntity {
  @Column("CLIENTID")
  private String clientId;
  
  @Column(value = "ONLINE", type = String.class)
  private int online;
  
  @Column(value = "\"enable\"", type = String.class)
  private int enable;
  
  public int setOnline(final int online) {
    return this.online = online;
  }
  
  public int getOnline() {
    return this.online;
  }
  
  public int setEnable(final int enable) {
    return this.enable = enable;
  }
  
  public int getEnable() {
    return this.enable;
  }
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("clientId", this.clientId);
    b.add("online", this.online);
    b.add("enable", this.enable);
    return b.toString();
  }
}
