/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.service;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.dao.entity.TaskDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskResultDaoEntity;
import cool.taomu.box.job.server.utils.ChineseToPinyin;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.job.server.utils.GitFileHistory;
import cool.taomu.box.script.rhino.JsRhinoScript;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback2;
import cool.taomu.box.utils.inter.ICallback3;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import joinery.DataFrame;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;

@SuppressWarnings("all")
public class TaskRunService {
  private static final Logger LOG = LoggerFactory.getLogger(TaskRunService.class);
  
  @Inject
  private TaskService taskService;
  
  @Inject
  private JGitTools jgit;
  
  public void taskResultProcessing(final File resultFile, final TaskDaoEntity entity) {
    try {
      final List<String> results = FileUtils.readLines(resultFile, "UTF-8");
      final ArrayList<FileWriteEntity> fileWriteList = new ArrayList<FileWriteEntity>();
      TaskRunService.LOG.info("需要处理运行结果行数:{}", Integer.valueOf(((Object[])Conversions.unwrapArray(results, Object.class)).length));
      final HashMap<String, Object> jsEnv = new HashMap<String, Object>();
      jsEnv.put("taskName", entity.getTaskName());
      jsEnv.put("taskId", entity.getTaskId());
      final String pyName = ChineseToPinyin.toPinyin(entity.getTaskName());
      List<TaskResultDaoEntity> htemplate = this.taskService.getAllByTaskId(entity.getTaskId());
      try {
        final Consumer<TaskResultDaoEntity> _function = (TaskResultDaoEntity it) -> {
          try {
            boolean _isEmpty = FileTools.isEmpty(it.getAnalyzeAndExtractFilePath());
            boolean _not = (!_isEmpty);
            if (_not) {
              jsEnv.put("analyzeAndExtractFilePath", 
                StringUtils.<String>defaultIfEmpty(it.getAnalyzeAndExtractFilePath(), ""));
              jsEnv.put("formatScriptFilePath", StringUtils.<String>defaultIfEmpty(it.getFormatScriptFilePath(), ""));
              jsEnv.put("name", StringUtils.<String>defaultIfEmpty(it.getName(), ""));
              jsEnv.put("pyname", StringUtils.<String>defaultIfEmpty(it.getPyName(), ""));
              final HashMap<String, Object> res = new HashMap<String, Object>();
              String _analyzeAndExtractFilePath = it.getAnalyzeAndExtractFilePath();
              File _file = new File(_analyzeAndExtractFilePath);
              String analysisFile = FileUtils.readFileToString(_file, "UTF-8");
              boolean _isNotBlank = StringUtils.isNotBlank(analysisFile);
              if (_isNotBlank) {
                try (JsRhinoScript js = new JsRhinoScript()) {
                  js.set("env", jsEnv);
                  js.set("res", res);
                  js.set("log", TaskRunService.LOG);
                  js.set("csv", new ICallback3<String, DataFrame>() {
                    @Override
                    public DataFrame read(final String name) {
                      try {
                        File f = GetTaskDirectory.getDataresult(pyName, 
                          IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(pyName, name, "result", "csv")), "."));
                        String c = FileUtils.readFileToString(f, "UTF-8");
                        return this.call(c);
                      } catch (Throwable _e) {
                        throw Exceptions.sneakyThrow(_e);
                      }
                    }
                    
                    @Override
                    public String path(final String name) {
                      File f = GetTaskDirectory.getDataresult(pyName, 
                        IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(pyName, name, "result", "csv")), "."));
                      return f.getAbsolutePath();
                    }
                    
                    @Override
                    public DataFrame call(final String content) {
                      try {
                        byte[] _bytes = content.getBytes();
                        ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
                        return DataFrame.readCsv(_byteArrayInputStream);
                      } catch (Throwable _e) {
                        throw Exceptions.sneakyThrow(_e);
                      }
                    }
                  });
                  js.set("newArrayList", new ICallback2<List<?>>() {
                    @Override
                    public List<?> call() {
                      return new ArrayList<Object>();
                    }
                  });
                  js.set("newHashMap", new ICallback2<Map<String, ?>>() {
                    @Override
                    public Map<String, ?> call() {
                      return new HashMap<String, Object>();
                    }
                  });
                  String _taskDirectory = entity.getTaskDirectory();
                  GitFileHistory _gitFileHistory = new GitFileHistory(this.jgit, _taskDirectory);
                  js.set("fileHistory", _gitFileHistory);
                  StringBuffer buffer = new StringBuffer("function taomubox_template_entry(results){");
                  buffer.append(analysisFile);
                  buffer.append(";}");
                  js.loaderScript(buffer.toString());
                  js.invoke("taomubox_template_entry", results);
                  TaskRunService.LOG.info("解析器返回结果:{}", res.toString());
                  this.saveRunResult(pyName, it, res, fileWriteList);
                }
              }
            } else {
              String _pyName = it.getPyName();
              File resFile = GetTaskDirectory.getResultPath(entity, IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_pyName, "result", "txt")), "."));
              TaskRunService.LOG.info("将结果保存到:{}", resFile.getAbsolutePath());
              it.setHtmlResultPath(resFile.getAbsolutePath().trim());
              String _htmlResultPath = it.getHtmlResultPath();
              String _join = IterableExtensions.join(results);
              FileWriteEntity _fileWriteEntity = new FileWriteEntity(_htmlResultPath, _join);
              fileWriteList.add(_fileWriteEntity);
            }
            this.taskService.updateTaskResult(it);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        };
        htemplate.forEach(_function);
        Integer _taskVersion = entity.getTaskVersion();
        int _plus = ((_taskVersion).intValue() + 1);
        entity.setTaskVersion(Integer.valueOf(_plus));
        final ICallback2<List<FileWriteEntity>> _function_1 = () -> {
          return fileWriteList;
        };
        this.taskService.FileWrite(GetTaskDirectory.getWorkspace(pyName), (entity.getTaskVersion()).intValue(), _function_1);
        entity.setStatus(TaskDaoEntity.TaskStatus.SUCCESS.ordinal());
        TaskRunService.LOG.info("任务 {} 更新数据库", entity.getTaskName());
        this.taskService.update(entity);
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception ex = (Exception)_t;
          ex.printStackTrace();
          entity.setStatus(TaskDaoEntity.TaskStatus.FAIL.ordinal());
          entity.setExceptionInfo(ex.getMessage());
          this.taskService.update(entity);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void saveRunResult(final String subPath, final TaskResultDaoEntity resEntity, final Map<String, Object> results, final List<FileWriteEntity> fileWriteList) {
    try {
      TaskRunService.LOG.info("保存运行结果");
      if ((results != null)) {
        TaskRunService.LOG.info("运行模版引擎生成格式化数据");
        boolean _endsWith = resEntity.getFormatScriptFilePath().endsWith(".mustache");
        if (_endsWith) {
          StringWriter writer = new StringWriter();
          DefaultMustacheFactory mf = new DefaultMustacheFactory();
          String _formatScriptFilePath = resEntity.getFormatScriptFilePath();
          FileInputStream _fileInputStream = new FileInputStream(_formatScriptFilePath);
          InputStreamReader reader = new InputStreamReader(_fileInputStream);
          Mustache mustache = mf.compile(reader, resEntity.getFormatScriptFilePath());
          mustache.execute(writer, results).flush();
          String _pyName = resEntity.getPyName();
          File resFile = GetTaskDirectory.getDataresult(subPath, 
            IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(subPath, _pyName, "mustache", "txt")), "."));
          TaskRunService.LOG.info("将结果保存到:{}", resFile.getAbsolutePath());
          resEntity.setHtmlResultPath(resFile.getAbsolutePath());
          String _string = writer.toString();
          String content = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_string)));
          String _absolutePath = resFile.getAbsolutePath();
          FileWriteEntity _fileWriteEntity = new FileWriteEntity(_absolutePath, content);
          fileWriteList.add(_fileWriteEntity);
        } else {
          boolean _endsWith_1 = resEntity.getFormatScriptFilePath().endsWith(".html");
          if (_endsWith_1) {
            String fsfPath = resEntity.getFormatScriptFilePath();
            String tempPath = fsfPath.substring(0, fsfPath.lastIndexOf(File.separator));
            int _lastIndexOf = fsfPath.lastIndexOf(File.separator);
            int _plus = (_lastIndexOf + 1);
            String tempName = fsfPath.substring(_plus, fsfPath.lastIndexOf("."));
            ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
            templateResolver.setPrefix(tempPath);
            templateResolver.setSuffix(".html");
            templateResolver.setTemplateMode(TemplateMode.HTML);
            TemplateEngine templateEngine = new TemplateEngine();
            templateEngine.setTemplateResolver(templateResolver);
            final Context context = new Context();
            final BiConsumer<String, Object> _function = (String k, Object v) -> {
              context.setVariable(k, v);
            };
            results.forEach(_function);
            String processedTemplate = templateEngine.process(tempName, context);
            String _pyName_1 = resEntity.getPyName();
            File resFile_1 = GetTaskDirectory.getDataresult(subPath, 
              IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(subPath, _pyName_1, "thymeleaf", "html")), "."));
            String content_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(processedTemplate)));
            String _absolutePath_1 = resFile_1.getAbsolutePath();
            FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_absolutePath_1, content_1);
            fileWriteList.add(_fileWriteEntity_1);
            resEntity.setHtmlResultPath(resFile_1.getAbsolutePath());
          }
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
