/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.service;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.dao.entity.TaskDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskResultDaoEntity;
import cool.taomu.box.job.server.service.TaskService;
import cool.taomu.box.job.server.utils.ChineseToPinyin;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.job.server.utils.GitFileHistory;
import cool.taomu.box.script.rhino.JsRhinoScript;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback2;
import cool.taomu.box.utils.inter.ICallback3;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import joinery.DataFrame;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class TaskRunService {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRunService.class);
    @Inject
    private TaskService taskService;
    @Inject
    private JGitTools jgit;

    public void taskResultProcessing(File resultFile, TaskDaoEntity entity) {
        block5: {
            try {
                List results = FileUtils.readLines((File)resultFile, (String)"UTF-8");
                ArrayList fileWriteList = new ArrayList();
                LOG.info("\u9700\u8981\u5904\u7406\u8fd0\u884c\u7ed3\u679c\u884c\u6570:{}", (Object)((Object[])Conversions.unwrapArray((Object)results, Object.class)).length);
                HashMap<String, String> jsEnv = new HashMap<String, String>();
                jsEnv.put("taskName", entity.getTaskName());
                jsEnv.put("taskId", entity.getTaskId());
                final String pyName = ChineseToPinyin.toPinyin(entity.getTaskName());
                List<TaskResultDaoEntity> htemplate = this.taskService.getAllByTaskId(entity.getTaskId());
                try {
                    Consumer<TaskResultDaoEntity> _function = it -> {
                        try {
                            boolean _not;
                            boolean _isEmpty = FileTools.isEmpty((String)it.getAnalyzeAndExtractFilePath());
                            boolean bl = _not = !_isEmpty;
                            if (_not) {
                                jsEnv.put("analyzeAndExtractFilePath", (String)StringUtils.defaultIfEmpty((CharSequence)it.getAnalyzeAndExtractFilePath(), (CharSequence)""));
                                jsEnv.put("formatScriptFilePath", (String)StringUtils.defaultIfEmpty((CharSequence)it.getFormatScriptFilePath(), (CharSequence)""));
                                jsEnv.put("name", (String)StringUtils.defaultIfEmpty((CharSequence)it.getName(), (CharSequence)""));
                                jsEnv.put("pyname", (String)StringUtils.defaultIfEmpty((CharSequence)it.getPyName(), (CharSequence)""));
                                HashMap<String, Object> res = new HashMap<String, Object>();
                                String _analyzeAndExtractFilePath = it.getAnalyzeAndExtractFilePath();
                                File _file = new File(_analyzeAndExtractFilePath);
                                String analysisFile = FileUtils.readFileToString((File)_file, (String)"UTF-8");
                                boolean _isNotBlank = StringUtils.isNotBlank((CharSequence)analysisFile);
                                if (_isNotBlank) {
                                    try (JsRhinoScript js = new JsRhinoScript();){
                                        js.set("env", (Object)jsEnv);
                                        js.set("res", res);
                                        js.set("log", (Object)LOG);
                                        js.set("csv", (Object)new ICallback3<String, DataFrame>(){

                                            public DataFrame read(String name) {
                                                try {
                                                    File f = GetTaskDirectory.getDataresult(pyName, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{pyName, name, "result", "csv"})), (CharSequence)"."));
                                                    String c = FileUtils.readFileToString((File)f, (String)"UTF-8");
                                                    return this.call(c);
                                                }
                                                catch (Throwable _e) {
                                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                                }
                                            }

                                            public String path(String name) {
                                                File f = GetTaskDirectory.getDataresult(pyName, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{pyName, name, "result", "csv"})), (CharSequence)"."));
                                                return f.getAbsolutePath();
                                            }

                                            public DataFrame call(String content) {
                                                try {
                                                    byte[] _bytes = content.getBytes();
                                                    ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
                                                    return DataFrame.readCsv((InputStream)_byteArrayInputStream);
                                                }
                                                catch (Throwable _e) {
                                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                                }
                                            }
                                        });
                                        js.set("newArrayList", (Object)new ICallback2<List<?>>(){

                                            public List<?> call() {
                                                return new ArrayList();
                                            }
                                        });
                                        js.set("newHashMap", (Object)new ICallback2<Map<String, ?>>(){

                                            public Map<String, ?> call() {
                                                return new HashMap();
                                            }
                                        });
                                        String _taskDirectory = entity.getTaskDirectory();
                                        GitFileHistory _gitFileHistory = new GitFileHistory(this.jgit, _taskDirectory);
                                        js.set("fileHistory", (Object)_gitFileHistory);
                                        StringBuffer buffer = new StringBuffer("function taomubox_template_entry(results){");
                                        buffer.append(analysisFile);
                                        buffer.append(";}");
                                        js.loaderScript(buffer.toString());
                                        js.invoke("taomubox_template_entry", new Object[]{results});
                                        LOG.info("\u89e3\u6790\u5668\u8fd4\u56de\u7ed3\u679c:{}", (Object)res.toString());
                                        this.saveRunResult(pyName, (TaskResultDaoEntity)it, (Map<String, Object>)res, fileWriteList);
                                    }
                                }
                            } else {
                                String _pyName = it.getPyName();
                                File resFile = GetTaskDirectory.getResultPath(entity, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_pyName, "result", "txt"})), (CharSequence)"."));
                                LOG.info("\u5c06\u7ed3\u679c\u4fdd\u5b58\u5230:{}", (Object)resFile.getAbsolutePath());
                                it.setHtmlResultPath(resFile.getAbsolutePath().trim());
                                String _htmlResultPath = it.getHtmlResultPath();
                                String _join = IterableExtensions.join((Iterable)results);
                                FileWriteEntity _fileWriteEntity = new FileWriteEntity(_htmlResultPath, _join);
                                fileWriteList.add(_fileWriteEntity);
                            }
                            this.taskService.updateTaskResult((TaskResultDaoEntity)it);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    };
                    htemplate.forEach(_function);
                    Integer _taskVersion = entity.getTaskVersion();
                    int _plus = _taskVersion + 1;
                    entity.setTaskVersion(_plus);
                    ICallback2 _function_1 = () -> fileWriteList;
                    this.taskService.FileWrite(GetTaskDirectory.getWorkspace(pyName), entity.getTaskVersion(), (ICallback2<List<FileWriteEntity>>)_function_1);
                    entity.setStatus(TaskDaoEntity.TaskStatus.SUCCESS.ordinal());
                    LOG.info("\u4efb\u52a1 {} \u66f4\u65b0\u6570\u636e\u5e93", (Object)entity.getTaskName());
                    this.taskService.update(entity);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception ex = (Exception)_t;
                        ex.printStackTrace();
                        entity.setStatus(TaskDaoEntity.TaskStatus.FAIL.ordinal());
                        entity.setExceptionInfo(ex.getMessage());
                        this.taskService.update(entity);
                        break block5;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public void saveRunResult(String subPath, TaskResultDaoEntity resEntity, Map<String, Object> results, List<FileWriteEntity> fileWriteList) {
        try {
            LOG.info("\u4fdd\u5b58\u8fd0\u884c\u7ed3\u679c");
            if (results != null) {
                LOG.info("\u8fd0\u884c\u6a21\u7248\u5f15\u64ce\u751f\u6210\u683c\u5f0f\u5316\u6570\u636e");
                boolean _endsWith = resEntity.getFormatScriptFilePath().endsWith(".mustache");
                if (_endsWith) {
                    StringWriter writer = new StringWriter();
                    DefaultMustacheFactory mf = new DefaultMustacheFactory();
                    String _formatScriptFilePath = resEntity.getFormatScriptFilePath();
                    FileInputStream _fileInputStream = new FileInputStream(_formatScriptFilePath);
                    InputStreamReader reader = new InputStreamReader(_fileInputStream);
                    Mustache mustache = mf.compile((Reader)reader, resEntity.getFormatScriptFilePath());
                    mustache.execute((Writer)writer, results).flush();
                    String _pyName = resEntity.getPyName();
                    File resFile = GetTaskDirectory.getDataresult(subPath, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{subPath, _pyName, "mustache", "txt"})), (CharSequence)"."));
                    LOG.info("\u5c06\u7ed3\u679c\u4fdd\u5b58\u5230:{}", (Object)resFile.getAbsolutePath());
                    resEntity.setHtmlResultPath(resFile.getAbsolutePath());
                    String _string = writer.toString();
                    String content = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_string})));
                    String _absolutePath = resFile.getAbsolutePath();
                    FileWriteEntity _fileWriteEntity = new FileWriteEntity(_absolutePath, content);
                    fileWriteList.add(_fileWriteEntity);
                } else {
                    boolean _endsWith_1 = resEntity.getFormatScriptFilePath().endsWith(".html");
                    if (_endsWith_1) {
                        String fsfPath = resEntity.getFormatScriptFilePath();
                        String tempPath = fsfPath.substring(0, fsfPath.lastIndexOf(File.separator));
                        int _lastIndexOf = fsfPath.lastIndexOf(File.separator);
                        int _plus = _lastIndexOf + 1;
                        String tempName = fsfPath.substring(_plus, fsfPath.lastIndexOf("."));
                        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
                        templateResolver.setPrefix(tempPath);
                        templateResolver.setSuffix(".html");
                        templateResolver.setTemplateMode(TemplateMode.HTML);
                        TemplateEngine templateEngine = new TemplateEngine();
                        templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
                        Context context = new Context();
                        BiConsumer<String, Object> _function = (k, v) -> context.setVariable(k, v);
                        results.forEach(_function);
                        String processedTemplate = templateEngine.process(tempName, (IContext)context);
                        String _pyName_1 = resEntity.getPyName();
                        File resFile_1 = GetTaskDirectory.getDataresult(subPath, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{subPath, _pyName_1, "thymeleaf", "html"})), (CharSequence)"."));
                        String content_1 = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{processedTemplate})));
                        String _absolutePath_1 = resFile_1.getAbsolutePath();
                        FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_absolutePath_1, content_1);
                        fileWriteList.add(_fileWriteEntity_1);
                        resEntity.setHtmlResultPath(resFile_1.getAbsolutePath());
                    }
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

