package cool.taomu.box.job.server.service;

import com.google.inject.Inject;
import cool.taomu.box.git.JGitTools;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.TaomuboxConfigure;
import cool.taomu.box.utils.inter.ICallback;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class TaskRepositoryService {
  @Accessors
  @ToString
  public static class FileEntity {
    private String name;
    
    private List<String> content = new ArrayList<String>();
    
    private String path = "";
    
    private String suffix = ".txt";
    
    public FileEntity(final String name) {
      this.name = name;
    }
    
    public FileEntity(final String name, final String suffix) {
      this.name = name;
      this.suffix = suffix;
    }
    
    public TaskRepositoryService.FileEntity content(final List<String> content) {
      this.content.addAll(content);
      return this;
    }
    
    public TaskRepositoryService.FileEntity path(final String path) {
      TaskRepositoryService.FileEntity _xblockexpression = null;
      {
        this.path = path;
        _xblockexpression = this;
      }
      return _xblockexpression;
    }
    
    @Pure
    public String getName() {
      return this.name;
    }
    
    public void setName(final String name) {
      this.name = name;
    }
    
    @Pure
    public List<String> getContent() {
      return this.content;
    }
    
    public void setContent(final List<String> content) {
      this.content = content;
    }
    
    @Pure
    public String getPath() {
      return this.path;
    }
    
    public void setPath(final String path) {
      this.path = path;
    }
    
    @Pure
    public String getSuffix() {
      return this.suffix;
    }
    
    public void setSuffix(final String suffix) {
      this.suffix = suffix;
    }
    
    @Override
    @Pure
    public String toString() {
      ToStringBuilder b = new ToStringBuilder(this);
      b.add("name", this.name);
      b.add("content", this.content);
      b.add("path", this.path);
      b.add("suffix", this.suffix);
      return b.toString();
    }
  }
  
  @Inject
  private JGitTools jgit;
  
  private final String basePath = TaomuboxConfigure.basePath;
  
  private String repositoryPath = "";
  
  public String repositoryPath(final String path) {
    String _xifexpression = null;
    boolean _contains = path.contains(this.basePath);
    if (_contains) {
      _xifexpression = path;
    } else {
      _xifexpression = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(this.basePath, path)), File.separator);
    }
    return this.repositoryPath = _xifexpression.trim();
  }
  
  public void init(final List<String> ignoreFiles) {
    try {
      this.jgit.setRepository(this.repositoryPath);
      this.jgit.init();
      if (((ignoreFiles != null) && (ignoreFiles.size() > 0))) {
        String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(this.repositoryPath, ".gitignore")), File.separator);
        File _file = new File(_join);
        FileUtils.writeLines(_file, "UTF-8", ignoreFiles);
        final ICallback<AddCommand> _function = (AddCommand it) -> {
          it.addFilepattern(".gitignore");
        };
        this.jgit.addAndCommit("add .gitignore file", _function);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void add(final List<TaskRepositoryService.FileEntity> fileList) {
    this.add("add file:", fileList);
  }
  
  public void add(final String msg, final List<TaskRepositoryService.FileEntity> fileList) {
    if (((fileList != null) && (fileList.size() > 0))) {
      final ArrayList<String> filePaths = new ArrayList<String>();
      final Consumer<TaskRepositoryService.FileEntity> _function = (TaskRepositoryService.FileEntity it) -> {
        try {
          String fileDir = this.repositoryPath;
          boolean _isNotBlank = StringUtils.isNotBlank(it.path);
          if (_isNotBlank) {
            String _path = it.getPath();
            String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(fileDir, _path)), File.separator);
            new File(_join).mkdirs();
          }
          String _path_1 = it.getPath();
          String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(it.name, it.suffix)), "");
          String _join_2 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(fileDir, _path_1, _join_1)), File.separator);
          File file = new File(_join_2);
          FileUtils.writeLines(file, "UTF-8", it.content);
          filePaths.add(FileTools.getSubdirectory((fileDir + File.separator), file.getAbsolutePath(), "/"));
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      fileList.forEach(_function);
      this.jgit.setRepository(this.repositoryPath);
      boolean _isAutoCommit = this.jgit.isAutoCommit();
      boolean _not = (!_isAutoCommit);
      if (_not) {
        this.jgit.setAutoCommit(true);
      }
      String _join = IterableExtensions.join(filePaths, "\n");
      final ICallback<AddCommand> _function_1 = (AddCommand it) -> {
        final Consumer<String> _function_2 = (String fpath) -> {
          it.addFilepattern(fpath);
        };
        filePaths.forEach(_function_2);
      };
      this.jgit.addAndCommit(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(msg, _join)), "\n"), _function_1);
    }
  }
  
  public void rm(final List<TaskRepositoryService.FileEntity> fileList) {
    this.rm("rm file:", fileList);
  }
  
  public void rm(final String msg, final List<TaskRepositoryService.FileEntity> fileList) {
    final ArrayList<String> filePaths = new ArrayList<String>();
    final Consumer<TaskRepositoryService.FileEntity> _function = (TaskRepositoryService.FileEntity it) -> {
      String fileDir = this.repositoryPath;
      String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(it.name, it.suffix)), "");
      String _join_1 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(fileDir, it.path, _join)), File.separator);
      File file = new File(_join_1);
      filePaths.add(FileTools.getSubdirectory((fileDir + File.separator), file.getAbsolutePath(), "/"));
    };
    fileList.forEach(_function);
    this.jgit.setRepository(this.repositoryPath);
    boolean _isAutoCommit = this.jgit.isAutoCommit();
    boolean _not = (!_isAutoCommit);
    if (_not) {
      this.jgit.setAutoCommit(true);
    }
    String _join = IterableExtensions.join(filePaths, "\n");
    final ICallback<RmCommand> _function_1 = (RmCommand it) -> {
      final Consumer<String> _function_2 = (String fpath) -> {
        it.addFilepattern(fpath);
      };
      filePaths.forEach(_function_2);
    };
    this.jgit.rmAndCommit(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(msg, _join)), "\n"), _function_1);
  }
}
