/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.controller;

import com.google.common.cache.Cache;
import cool.taomu.box.job.server.controller.entity.LoginEntity;
import cool.taomu.box.job.server.dao.entity.UserDaoEntity;
import cool.taomu.box.job.server.service.EmailService;
import cool.taomu.box.job.server.service.UserService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/user")
public class LoginController {
    private static final Logger LOG = LoggerFactory.getLogger(LoginController.class);
    @Inject
    @Named(value="taomubox.title")
    private String title;
    @Inject
    @Named(value="taomubox.http.pathSpec")
    private String pathSpec = "";
    @Inject
    @Named(value="taomubox.http.auth.admin")
    private String adminUserName;
    @Inject
    @Named(value="taomubox.http.auth.email")
    private String adminEmail;
    @Inject
    private UserService uservice;
    @Inject
    private EmailService emailService;
    @Inject
    private Cache<String, String> codeCache;

    @GET
    @Path(value="/verify/code/{userName}")
    @Produces(value={"application/json"})
    public Response sendCode(@PathParam(value="userName") String userName) {
        LOG.info("\u5411\u7528\u6237\u90ae\u7bb1\u53d1\u9001\u9a8c\u8bc1\u7801");
        boolean _containsKey = this.codeCache.asMap().containsKey(userName);
        if (_containsKey) {
            return Response.status((int)201).build();
        }
        UserDaoEntity entity = this.uservice.getUserEntityByUsername(userName);
        if (entity != null || this.adminUserName.equals(userName.trim())) {
            this.codeCache.put((Object)userName, (Object)"1233ab");
            try {
                LOG.info("\u5411\u7528\u6237\u90ae\u7bb1\u53d1\u9001\u52a8\u6001\u5bc6\u7801");
                boolean _equals = userName.equals(this.adminUserName);
                if (_equals) {
                    this.emailService.sendEmail(this.adminEmail, "\u52a8\u6001\u5bc6\u7801", (String)this.codeCache.getIfPresent((Object)userName));
                } else {
                    this.emailService.sendEmail(entity.getEmail(), "\u52a8\u6001\u5bc6\u7801", (String)this.codeCache.getIfPresent((Object)userName));
                }
                return Response.ok().build();
            }
            catch (Throwable _t) {
                if (_t instanceof MessagingException) {
                    MessagingException e = (MessagingException)_t;
                    this.codeCache.invalidate((Object)userName);
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        this.codeCache.invalidate((Object)userName);
        return Response.status((int)500).build();
    }

    @POST
    @Path(value="/login")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response login(@Context HttpServletRequest request, LoginEntity entity) {
        UserDaoEntity uentity_1;
        if (entity.getUserName().trim().equals(this.adminUserName) && this.codeCache.getIfPresent((Object)entity.getUserName()) != null && ((String)this.codeCache.getIfPresent((Object)entity.getUserName())).equals(entity.getVerifyCode())) {
            boolean _tripleEquals;
            HttpSession session = request.getSession(true);
            session.setAttribute("user_login_tag", (Object)entity.getUserName().trim());
            UserDaoEntity _userEntityByUsername = this.uservice.getUserEntityByUsername(entity.getUserName().trim());
            boolean bl = _tripleEquals = _userEntityByUsername == null;
            if (_tripleEquals) {
                boolean _greaterThan;
                UserDaoEntity uentity = new UserDaoEntity();
                uentity.setUserName(entity.getUserName().trim());
                int _saveUser = this.uservice.saveUser(uentity);
                boolean bl2 = _greaterThan = _saveUser > 0;
                if (_greaterThan) {
                    uentity = this.uservice.getUserEntityByUsername(uentity.getUserName());
                    this.codeCache.invalidate((Object)entity.getUserName());
                    return Response.status((int)304).entity((Object)uentity).build();
                }
            }
        }
        if ((uentity_1 = this.uservice.getUserEntityByUsername(entity.getUserName().trim())) != null && this.codeCache.getIfPresent((Object)entity.getUserName()) != null && ((String)this.codeCache.getIfPresent((Object)entity.getUserName())).equals(entity.getVerifyCode())) {
            this.codeCache.invalidate((Object)entity.getUserName());
            return Response.status((int)304).entity((Object)uentity_1).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/logout")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response logout(@Context HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object _attribute = session.getAttribute("user_login_tag");
        String userName = (String)_attribute;
        LOG.info("\u7528\u6237{}\u9000\u51fa\u4e86", (Object)userName);
        session.removeAttribute("user_login_tag");
        UserDaoEntity userEntity = this.uservice.getUserEntityByUsername(userName.trim());
        if (userEntity != null) {
            return Response.ok().build();
        }
        return Response.ok().build();
    }
}

