/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.controller.impl;

import cool.taomu.box.job.server.service.SecurityService;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AuthFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
    @Inject
    private SecurityService securityService;
    @Inject
    @Named(value="taomubox.http.auth.value")
    private boolean isAuth;
    @Context
    private HttpServletRequest request;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        LOG.info("\u8fc7\u6ee4\u89c4\u5219");
        if (this.isAuth) {
            try {
                LOG.info("\u7528\u6237\u6388\u6743\u5224\u65ad");
                String path = requestContext.getUriInfo().getPath();
                boolean contains = StringUtils.containsAny((CharSequence)path, (CharSequence[])new CharSequence[]{"index", "task/list", "user/verify", "user/login"});
                if (contains) {
                    return;
                }
                HttpSession session = this.request.getSession();
                Object value = session.getAttribute("user_login_tag");
                if (value != null && value.equals("admin")) {
                    LOG.info("\u83b7\u53d6\u5230\u6b63\u786e\u7684\u503c! [" + value + "]");
                    return;
                }
                String authorizationHeader = requestContext.getHeaderString("Authorization");
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                return;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    ex.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }
}

