package cool.taomu.box.job.server.dao;

import cool.taomu.box.job.server.dao.entity.DataProcessingDaoEntity;
import cool.taomu.box.job.server.dao.provider.TaskDataProcessingDaoProvider;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.type.JdbcType;

@Mapper
@SuppressWarnings("all")
public interface TaskDataProcessingDao {
  @InsertProvider(type = TaskDataProcessingDaoProvider.class, method = "insert")
  int saveDataSource(@Param("t") final DataProcessingDaoEntity t);
  
  @Delete("delete from TAOMUBOX_JOB_DATA_PROCESSING where uuid = #{uuid}")
  int deleteOneDataProcessing(@Param("uuid") final String uuid);
  
  @Result(property = "uuid", column = "uuid", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "name", column = "name", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "dataProcessingType", column = "DATA_PROCESSING_TYPE", javaType = int.class, jdbcType = JdbcType.INTEGER)
  @Result(property = "extendColumn", column = "EXTEND_COLUMN", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "scriptFilePath", column = "script_file_path", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Select("select * from TAOMUBOX_JOB_DATA_PROCESSING where uuid = #{uuid}")
  DataProcessingDaoEntity getOneByUuId(@Param("uuid") final String uuid);
}
