package cool.taomu.box.job.server.dao.entity;

import cool.taomu.box.mybatis.plus.ann.Column;
import cool.taomu.box.mybatis.plus.ann.Table;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@Table("TAOMUBOX_JOB_DATA_SOURCE")
@SuppressWarnings("all")
public class DataSourceDaoEntity {
  public enum DataSourceTypeEnum {
    NONE,
    
    GIT,
    
    FTP,
    
    SFTP,
    
    SMB,
    
    JDBC,
    
    MQTT_SUBSCRIBE,
    
    本地文件;
  }
  
  @Column(value = "uuid")
  private String uuid;
  
  @Column(value = "name")
  private String name;
  
  @Column(value = "datasource_type")
  private int dataSourceType = DataSourceDaoEntity.DataSourceTypeEnum.NONE.ordinal();
  
  @Column(value = "address")
  private String address;
  
  /**
   * u/p 数据来源授权信息RSA加密
   */
  @Column(value = "authorize_info")
  private String authorizeInfo;
  
  @Column(value = "script_file_path")
  private String scriptFilePath;
  
  @Pure
  public String getUuid() {
    return this.uuid;
  }
  
  public void setUuid(final String uuid) {
    this.uuid = uuid;
  }
  
  @Pure
  public String getName() {
    return this.name;
  }
  
  public void setName(final String name) {
    this.name = name;
  }
  
  @Pure
  public int getDataSourceType() {
    return this.dataSourceType;
  }
  
  public void setDataSourceType(final int dataSourceType) {
    this.dataSourceType = dataSourceType;
  }
  
  @Pure
  public String getAddress() {
    return this.address;
  }
  
  public void setAddress(final String address) {
    this.address = address;
  }
  
  @Pure
  public String getAuthorizeInfo() {
    return this.authorizeInfo;
  }
  
  public void setAuthorizeInfo(final String authorizeInfo) {
    this.authorizeInfo = authorizeInfo;
  }
  
  @Pure
  public String getScriptFilePath() {
    return this.scriptFilePath;
  }
  
  public void setScriptFilePath(final String scriptFilePath) {
    this.scriptFilePath = scriptFilePath;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("uuid", this.uuid);
    b.add("name", this.name);
    b.add("dataSourceType", this.dataSourceType);
    b.add("address", this.address);
    b.add("authorizeInfo", this.authorizeInfo);
    b.add("scriptFilePath", this.scriptFilePath);
    return b.toString();
  }
}
