/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.service;

import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailService {
    private static final Logger LOG = LoggerFactory.getLogger(EmailService.class);
    @Inject
    private Session session;
    @Inject
    @Named(value="taomubox.mail.from")
    private String from;

    public void sendEmail(String to, String subject, String body) {
        try {
            try {
                MimeMessage message = new MimeMessage(this.session);
                InternetAddress _internetAddress = new InternetAddress(this.from);
                message.setFrom((Address)_internetAddress);
                message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
                message.setSubject(subject);
                message.setText(body);
                Transport.send((Message)message);
            }
            catch (Throwable _t) {
                if (_t instanceof MessagingException) {
                    MessagingException e = (MessagingException)_t;
                    LOG.info(e.getMessage());
                    e.printStackTrace();
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

