package cool.taomu.box.job.server.dao;

import cool.taomu.box.job.server.dao.entity.TaskResultDaoEntity;
import cool.taomu.box.job.server.dao.provider.TaskResultDaoProvider;
import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.type.JdbcType;

@Mapper
@SuppressWarnings("all")
public interface TaskResultDao {
  @InsertProvider(type = TaskResultDaoProvider.class, method = "insert")
  int saveDataSource(@Param("t") final TaskResultDaoEntity t);
  
  @Delete("delete from TAOMUBOX_JOB_TASK_RESULT where uuid = #{uuid}")
  int deleteOneTaskResultByUuid(@Param("uuid") final String uuid);
  
  @Delete("delete from TAOMUBOX_JOB_TASK_RESULT where task_id = #{taskId}")
  int deleteOneTaskResultByTaskId(@Param("taskId") final String taskId);
  
  @Result(property = "taskId", column = "task_id", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "name", column = "name", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "uuid", column = "uuid", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "pyName", column = "pinyin_name", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "htmlResultPath", column = "HTML_RESULT_PATH", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "formatScriptFilePath", column = "format_script_file_path", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Result(property = "analyzeAndExtractFilePath", column = "ANALYZE_AND_EXTRACT_FILE_PATH", javaType = String.class, jdbcType = JdbcType.VARCHAR)
  @Select("select * from TAOMUBOX_JOB_TASK_RESULT where task_id = #{taskId}")
  List<TaskResultDaoEntity> getAllByTaskId(@Param("taskId") final String taskId);
}
