/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.dao.entity;

import cool.taomu.box.mybatis.plus.ann.Column;
import cool.taomu.box.mybatis.plus.ann.Table;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@Table("TAOMUBOX_JOB_TASK")
@SuppressWarnings("all")
public class TaskDaoEntity {
  public enum TaskStatus {
    FAIL,
    
    SUCCESS,
    
    WAIT,
    
    READY,
    
    IN_PROGRESS,
    
    DONE,
    
    UNKNOWN;
  }
  
  @Column(value = "task_id")
  private String taskId;
  
  @Column(value = "client_id")
  private String clientId;
  
  @Column(value = "task_name")
  private String taskName = "unknown";
  
  @Column(value = "STATUS")
  private int status = TaskDaoEntity.TaskStatus.UNKNOWN.ordinal();
  
  @Column(value = "RUN_TIMESTMAP")
  private long runTimestamp = 0;
  
  @Column(value = "TASK_CREATE_TIMESTMAP")
  private long taskAddTimestmap = System.currentTimeMillis();
  
  @Column(value = "schedule")
  private String schedule = "";
  
  @Column(value = "is_schedule_task")
  private boolean isScheduledTask = false;
  
  @Column(value = "task_version")
  private Integer taskVersion;
  
  @Column(value = "exception_info")
  private String exceptionInfo = "";
  
  @Column(value = "EXTEND_COLUMN")
  private String extendColumn;
  
  @Column(value = "task_directory")
  private String taskDirectory;
  
  @Column(value = "DATASOURCE_ID")
  private String datasourceId;
  
  @Column(value = "DATA_PROCESSING_ID")
  private String dataProcessingId;
  
  @Column(value = "dependent_task_id")
  private String dependentTaskId;
  
  @Pure
  public String getTaskId() {
    return this.taskId;
  }
  
  public void setTaskId(final String taskId) {
    this.taskId = taskId;
  }
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Pure
  public String getTaskName() {
    return this.taskName;
  }
  
  public void setTaskName(final String taskName) {
    this.taskName = taskName;
  }
  
  @Pure
  public int getStatus() {
    return this.status;
  }
  
  public void setStatus(final int status) {
    this.status = status;
  }
  
  @Pure
  public long getRunTimestamp() {
    return this.runTimestamp;
  }
  
  public void setRunTimestamp(final long runTimestamp) {
    this.runTimestamp = runTimestamp;
  }
  
  @Pure
  public long getTaskAddTimestmap() {
    return this.taskAddTimestmap;
  }
  
  public void setTaskAddTimestmap(final long taskAddTimestmap) {
    this.taskAddTimestmap = taskAddTimestmap;
  }
  
  @Pure
  public String getSchedule() {
    return this.schedule;
  }
  
  public void setSchedule(final String schedule) {
    this.schedule = schedule;
  }
  
  @Pure
  public boolean isScheduledTask() {
    return this.isScheduledTask;
  }
  
  public void setIsScheduledTask(final boolean isScheduledTask) {
    this.isScheduledTask = isScheduledTask;
  }
  
  @Pure
  public Integer getTaskVersion() {
    return this.taskVersion;
  }
  
  public void setTaskVersion(final Integer taskVersion) {
    this.taskVersion = taskVersion;
  }
  
  @Pure
  public String getExceptionInfo() {
    return this.exceptionInfo;
  }
  
  public void setExceptionInfo(final String exceptionInfo) {
    this.exceptionInfo = exceptionInfo;
  }
  
  @Pure
  public String getExtendColumn() {
    return this.extendColumn;
  }
  
  public void setExtendColumn(final String extendColumn) {
    this.extendColumn = extendColumn;
  }
  
  @Pure
  public String getTaskDirectory() {
    return this.taskDirectory;
  }
  
  public void setTaskDirectory(final String taskDirectory) {
    this.taskDirectory = taskDirectory;
  }
  
  @Pure
  public String getDatasourceId() {
    return this.datasourceId;
  }
  
  public void setDatasourceId(final String datasourceId) {
    this.datasourceId = datasourceId;
  }
  
  @Pure
  public String getDataProcessingId() {
    return this.dataProcessingId;
  }
  
  public void setDataProcessingId(final String dataProcessingId) {
    this.dataProcessingId = dataProcessingId;
  }
  
  @Pure
  public String getDependentTaskId() {
    return this.dependentTaskId;
  }
  
  public void setDependentTaskId(final String dependentTaskId) {
    this.dependentTaskId = dependentTaskId;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("taskId", this.taskId);
    b.add("clientId", this.clientId);
    b.add("taskName", this.taskName);
    b.add("status", this.status);
    b.add("runTimestamp", this.runTimestamp);
    b.add("taskAddTimestmap", this.taskAddTimestmap);
    b.add("schedule", this.schedule);
    b.add("isScheduledTask", this.isScheduledTask);
    b.add("taskVersion", this.taskVersion);
    b.add("exceptionInfo", this.exceptionInfo);
    b.add("extendColumn", this.extendColumn);
    b.add("taskDirectory", this.taskDirectory);
    b.add("datasourceId", this.datasourceId);
    b.add("dataProcessingId", this.dataProcessingId);
    b.add("dependentTaskId", this.dependentTaskId);
    return b.toString();
  }
}
