/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.controller;

import cool.taomu.box.job.server.dao.MqttUserDao;
import cool.taomu.box.job.server.entity.MqttSubscribeEntity;
import cool.taomu.box.job.server.entity.MqttUserEntity;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Path("job/mqtt/user")
@SuppressWarnings("all")
public class MqttUserController {
  @Inject
  private MqttUserDao userDao;
  
  @GET
  @Path("/subscribe")
  @Produces(MediaType.APPLICATION_JSON)
  public List<MqttSubscribeEntity> subscribe() {
    return this.userDao.selectSubscribeAll();
  }
  
  @GET
  @Path("/subscribe/{clientid}")
  @Produces(MediaType.APPLICATION_JSON)
  public List<MqttSubscribeEntity> subscribeOne(@PathParam("clientid") final String cid) {
    return this.userDao.selectSubscribeByClientId(cid);
  }
  
  @GET
  @Path("{clientid}")
  @Produces(MediaType.APPLICATION_JSON)
  public MqttUserEntity getUser(@PathParam("clientid") final String cid) {
    return this.userDao.selectByClientId(cid);
  }
  
  @GET
  @Produces(MediaType.APPLICATION_JSON)
  public List<MqttUserEntity> getUserAll() {
    return this.userDao.selectAll();
  }
  
  @POST
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_JSON)
  public String addUser(final MqttUserEntity body) {
    String _xblockexpression = null;
    {
      this.userDao.addUser(body.getClientId(), body.getOnline(), body.getEnable());
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
  
  @PUT
  @Path("{clientid}")
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_JSON)
  public String moidfyUser(@PathParam("clientid") final String cid, final MqttUserEntity body) {
    return null;
  }
  
  @DELETE
  @Path("{clientid}")
  @Produces(MediaType.TEXT_PLAIN)
  public String delUser(@PathParam("clientid") final String cid) {
    String _xblockexpression = null;
    {
      this.userDao.deleteByClientId(cid);
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
}
