/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.server.controller.impl;

import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.controller.abs.AbsPreTaskAndPostTask;
import cool.taomu.box.job.server.controller.entity.DataProcessingEntity;
import cool.taomu.box.job.server.controller.entity.DataSourceEntity;
import cool.taomu.box.job.server.controller.entity.FileWriteEntity;
import cool.taomu.box.job.server.controller.entity.HtmlTemplateEntity;
import cool.taomu.box.job.server.controller.entity.ResponseEntity;
import cool.taomu.box.job.server.controller.entity.TaskDataResultEntity;
import cool.taomu.box.job.server.controller.entity.TaskResultEntity;
import cool.taomu.box.job.server.controller.inter.ITaskController;
import cool.taomu.box.job.server.dao.entity.DataProcessingDaoEntity;
import cool.taomu.box.job.server.dao.entity.DataSourceDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskDaoEntity;
import cool.taomu.box.job.server.dao.entity.TaskResultDaoEntity;
import cool.taomu.box.job.server.script.runtime.DataSource;
import cool.taomu.box.job.server.script.runtime.GTask;
import cool.taomu.box.job.server.service.TaskRunService;
import cool.taomu.box.job.server.service.TaskService;
import cool.taomu.box.job.server.utils.ChineseToPinyin;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.job.server.utils.MarkdownUtils;
import cool.taomu.box.script.groovy.GroovyDsl;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.TaomuboxConfigure;
import cool.taomu.box.utils.inter.ICallback;
import cool.taomu.box.utils.inter.ICallback2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("job")
@SuppressWarnings("all")
public class TaskController implements ITaskController<TaskDaoEntity> {
  @Accessors
  public static class RespTaskEntity {
    private String taskId;
    
    private String taskName;
    
    private DataSourceDaoEntity dataSource;
    
    private DataProcessingEntity dataProcessing;
    
    private List<TaskDataResultEntity> taskResultList;
    
    @Pure
    public String getTaskId() {
      return this.taskId;
    }
    
    public void setTaskId(final String taskId) {
      this.taskId = taskId;
    }
    
    @Pure
    public String getTaskName() {
      return this.taskName;
    }
    
    public void setTaskName(final String taskName) {
      this.taskName = taskName;
    }
    
    @Pure
    public DataSourceDaoEntity getDataSource() {
      return this.dataSource;
    }
    
    public void setDataSource(final DataSourceDaoEntity dataSource) {
      this.dataSource = dataSource;
    }
    
    @Pure
    public DataProcessingEntity getDataProcessing() {
      return this.dataProcessing;
    }
    
    public void setDataProcessing(final DataProcessingEntity dataProcessing) {
      this.dataProcessing = dataProcessing;
    }
    
    @Pure
    public List<TaskDataResultEntity> getTaskResultList() {
      return this.taskResultList;
    }
    
    public void setTaskResultList(final List<TaskDataResultEntity> taskResultList) {
      this.taskResultList = taskResultList;
    }
  }
  
  private static final Logger LOG = LoggerFactory.getLogger(TaskController.class);
  
  @Inject
  private TaskService taskService;
  
  @Inject
  private JGitTools jgit;
  
  @Inject
  private AbsPreTaskAndPostTask iTask;
  
  @Inject
  private TaskRunService trunService;
  
  @Inject
  private GTask task;
  
  private Response OK = Response.ok().build();
  
  @POST
  @Path("/task/datasource")
  @Consumes(MediaType.APPLICATION_JSON)
  public Response postTaskDataSource(final List<DataSourceEntity> entity) {
    TaskController.LOG.info(entity.toString());
    DataSourceEntity dsEntity = entity.get(0);
    String dataSourceUuid = UUID.randomUUID().toString();
    boolean _equals = dsEntity.getTaskId().equals("None");
    if (_equals) {
      String pyname = ChineseToPinyin.toPinyin(dsEntity.getTaskName());
      DataSourceDaoEntity dsDaoEntity = new DataSourceDaoEntity();
      String _address = dsEntity.getAddress();
      String _branches = dsEntity.getBranches();
      dsDaoEntity.setAddress(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_address, "(", _branches, ")")), ""));
      dsDaoEntity.setAuthorizeInfo(dsEntity.getAuthorizeInfo());
      dsDaoEntity.setDataSourceType(dsEntity.getDataSourceType());
      dsDaoEntity.setName(dsEntity.getName());
      dsDaoEntity.setScriptFilePath("");
      dsDaoEntity.setUuid(dataSourceUuid);
      int _saveTaskDataSource = this.taskService.saveTaskDataSource(dsDaoEntity);
      boolean _greaterThan = (_saveTaskDataSource > 0);
      if (_greaterThan) {
        TaskDaoEntity createTaskEntity = new TaskDaoEntity();
        createTaskEntity.setTaskName(dsEntity.getTaskName());
        createTaskEntity.setTaskId(UUID.randomUUID().toString());
        createTaskEntity.setDatasourceId(dataSourceUuid);
        createTaskEntity.setTaskVersion(Integer.valueOf((-1)));
        createTaskEntity.setTaskDirectory(GetTaskDirectory.getWorkspace(pyname));
        this.taskService.saveTask(createTaskEntity);
        String _taskId = createTaskEntity.getTaskId();
        Pair<String, String> _mappedTo = Pair.<String, String>of("taskId", _taskId);
        return Response.status(201).entity(Collections.<Pair<String, String>>unmodifiableList(CollectionLiterals.<Pair<String, String>>newArrayList(_mappedTo))).build();
      }
    } else {
      TaskDaoEntity taskEntity = this.taskService.getOneTask(dsEntity.getTaskId());
      if (((taskEntity != null) && StringUtils.isNotBlank(taskEntity.getDatasourceId()))) {
        DataSourceDaoEntity dsDaoEntity_1 = new DataSourceDaoEntity();
        dsDaoEntity_1.setAddress(dsEntity.getAddress());
        dsDaoEntity_1.setAuthorizeInfo(dsEntity.getAuthorizeInfo());
        dsDaoEntity_1.setDataSourceType(dsEntity.getDataSourceType());
        dsDaoEntity_1.setName(dsEntity.getName());
        dsDaoEntity_1.setScriptFilePath("");
        dsDaoEntity_1.setUuid(taskEntity.getDatasourceId());
        this.taskService.updateTaskDataSource(dsDaoEntity_1);
      } else {
        DataSourceDaoEntity dsDaoEntity_2 = new DataSourceDaoEntity();
        dsDaoEntity_2.setAddress(dsEntity.getAddress());
        dsDaoEntity_2.setAuthorizeInfo(dsEntity.getAuthorizeInfo());
        dsDaoEntity_2.setDataSourceType(dsEntity.getDataSourceType());
        dsDaoEntity_2.setName(dsEntity.getName());
        dsDaoEntity_2.setScriptFilePath("");
        dsDaoEntity_2.setUuid(dataSourceUuid);
        int _saveTaskDataSource_1 = this.taskService.saveTaskDataSource(dsDaoEntity_2);
        boolean _greaterThan_1 = (_saveTaskDataSource_1 > 0);
        if (_greaterThan_1) {
          taskEntity.setDatasourceId(dataSourceUuid);
          this.taskService.update(taskEntity);
        }
      }
      String _taskId_1 = taskEntity.getTaskId();
      Pair<String, String> _mappedTo_1 = Pair.<String, String>of("taskId", _taskId_1);
      return Response.status(201).entity(Collections.<Pair<String, String>>unmodifiableList(CollectionLiterals.<Pair<String, String>>newArrayList(_mappedTo_1))).build();
    }
    return Response.status(500).build();
  }
  
  @POST
  @Path("/task/dataprocessing")
  @Consumes(MediaType.APPLICATION_JSON)
  public Response postTaskDataProcessing(final List<DataProcessingEntity> entity) {
    TaskController.LOG.info(entity.toString());
    DataProcessingEntity dpEntity = entity.get(0);
    String dprocessingUuid = UUID.randomUUID().toString();
    final ArrayList<FileWriteEntity> fileWriteList = new ArrayList<FileWriteEntity>();
    String pyname = ChineseToPinyin.toPinyin(dpEntity.getTaskName());
    boolean _equals = dpEntity.getTaskId().equals("None");
    if (_equals) {
      DataProcessingDaoEntity datapEntity = new DataProcessingDaoEntity();
      datapEntity.setUuid(dprocessingUuid);
      datapEntity.setName(dpEntity.getName());
      File dir = GetTaskDirectory.getDataprocessing(pyname, IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(pyname, "task")), "."));
      String _absolutePath = dir.getAbsolutePath();
      String _dataProcessingScript = dpEntity.getDataProcessingScript();
      FileWriteEntity _fileWriteEntity = new FileWriteEntity(_absolutePath, _dataProcessingScript);
      fileWriteList.add(_fileWriteEntity);
      datapEntity.setScriptFilePath(dir.getAbsolutePath());
      int _saveTaskDataProcessing = this.taskService.saveTaskDataProcessing(datapEntity);
      boolean _greaterThan = (_saveTaskDataProcessing > 0);
      if (_greaterThan) {
        TaskDaoEntity createTaskEntity = new TaskDaoEntity();
        createTaskEntity.setTaskName(dpEntity.getTaskName());
        createTaskEntity.setTaskId(UUID.randomUUID().toString());
        createTaskEntity.setDataProcessingId(dprocessingUuid);
        createTaskEntity.setTaskVersion(Integer.valueOf(0));
        createTaskEntity.setTaskDirectory(GetTaskDirectory.getWorkspace(pyname));
        this.taskService.saveTask(createTaskEntity);
        final ICallback2<List<FileWriteEntity>> _function = () -> {
          return fileWriteList;
        };
        this.taskService.FileWrite(GetTaskDirectory.getWorkspace(pyname), (createTaskEntity.getTaskVersion()).intValue(), _function);
        String _taskId = createTaskEntity.getTaskId();
        Pair<String, String> _mappedTo = Pair.<String, String>of("taskId", _taskId);
        return Response.status(201).entity(Collections.<Pair<String, String>>unmodifiableList(CollectionLiterals.<Pair<String, String>>newArrayList(_mappedTo))).build();
      }
    } else {
      TaskDaoEntity taskEntity = this.taskService.getOneTask(dpEntity.getTaskId());
      if (((taskEntity != null) && StringUtils.isNotBlank(taskEntity.getDataProcessingId()))) {
        DataProcessingDaoEntity datapEntity_1 = new DataProcessingDaoEntity();
        datapEntity_1.setUuid(dprocessingUuid);
        datapEntity_1.setName(dpEntity.getName());
        File dir_1 = GetTaskDirectory.getDataprocessing(pyname, IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(pyname, "task")), "."));
        String _absolutePath_1 = dir_1.getAbsolutePath();
        String _dataProcessingScript_1 = dpEntity.getDataProcessingScript();
        FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_absolutePath_1, _dataProcessingScript_1);
        fileWriteList.add(_fileWriteEntity_1);
        datapEntity_1.setScriptFilePath(dir_1.getAbsolutePath());
        datapEntity_1.setUuid(taskEntity.getDataProcessingId());
        this.taskService.updateTaskDataProcessing(datapEntity_1);
      } else {
        DataProcessingDaoEntity datapEntity_2 = new DataProcessingDaoEntity();
        datapEntity_2.setUuid(dprocessingUuid);
        datapEntity_2.setName(dpEntity.getName());
        File dir_2 = GetTaskDirectory.getDataprocessing(pyname, IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(pyname, "task")), "."));
        String _absolutePath_2 = dir_2.getAbsolutePath();
        String _dataProcessingScript_2 = dpEntity.getDataProcessingScript();
        FileWriteEntity _fileWriteEntity_2 = new FileWriteEntity(_absolutePath_2, _dataProcessingScript_2);
        fileWriteList.add(_fileWriteEntity_2);
        datapEntity_2.setScriptFilePath(dir_2.getAbsolutePath());
        int _saveTaskDataProcessing_1 = this.taskService.saveTaskDataProcessing(datapEntity_2);
        boolean _greaterThan_1 = (_saveTaskDataProcessing_1 > 0);
        if (_greaterThan_1) {
          taskEntity.setDataProcessingId(dprocessingUuid);
        }
      }
      Integer _taskVersion = taskEntity.getTaskVersion();
      int _plus = ((_taskVersion).intValue() + 1);
      taskEntity.setTaskVersion(Integer.valueOf(_plus));
      this.taskService.update(taskEntity);
      final ICallback2<List<FileWriteEntity>> _function_1 = () -> {
        return fileWriteList;
      };
      this.taskService.FileWrite(GetTaskDirectory.getWorkspace(pyname), (taskEntity.getTaskVersion()).intValue(), _function_1);
      String _taskId_1 = taskEntity.getTaskId();
      Pair<String, String> _mappedTo_1 = Pair.<String, String>of("taskId", _taskId_1);
      return Response.status(201).entity(Collections.<Pair<String, String>>unmodifiableList(CollectionLiterals.<Pair<String, String>>newArrayList(_mappedTo_1))).build();
    }
    return Response.status(500).build();
  }
  
  @POST
  @Path("/task/taskresult")
  @Consumes(MediaType.APPLICATION_JSON)
  public Response postTaskDataResult(final List<TaskDataResultEntity> entity) {
    TaskController.LOG.info(entity.toString());
    int _size = entity.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      final String taskId = entity.get(0).getTaskId();
      final String pyTaskName = ChineseToPinyin.toPinyin(entity.get(0).getTaskName());
      final TaskDaoEntity taskEntity = this.taskService.getOneTask(taskId);
      final ArrayList<FileWriteEntity> fileWriteList = new ArrayList<FileWriteEntity>();
      if ((taskId != null)) {
        this.taskService.deleteTaskResultByTaskId(taskId);
        final Consumer<TaskDataResultEntity> _function = (TaskDataResultEntity it) -> {
          String _taskId = it.getTaskId();
          boolean _tripleNotEquals = (_taskId != null);
          if (_tripleNotEquals) {
            TaskResultDaoEntity dsDaoEntity = new TaskResultDaoEntity();
            dsDaoEntity.setName(it.getName());
            dsDaoEntity.setTaskId(taskId);
            dsDaoEntity.setPyName(ChineseToPinyin.toPinyin(it.getName()));
            dsDaoEntity.setHtmlResultPath("");
            String _pyName = dsDaoEntity.getPyName();
            File aneTextFile = GetTaskDirectory.getAnalysisPath(pyTaskName, 
              IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_pyName, "analyze", "js")), "."));
            String _absolutePath = aneTextFile.getAbsolutePath();
            String _analyzeAndExtractText = it.getAnalyzeAndExtractText();
            FileWriteEntity _fileWriteEntity = new FileWriteEntity(_absolutePath, _analyzeAndExtractText);
            fileWriteList.add(_fileWriteEntity);
            dsDaoEntity.setAnalyzeAndExtractFilePath(aneTextFile.getAbsolutePath());
            Perl5Util p5 = new Perl5Util();
            boolean _match = p5.match("/^#![^?.]*mustache[^?.]*$/", it.getFormatScriptText().trim());
            if (_match) {
              it.setFormatScriptText(it.getFormatScriptText().replaceFirst("#![^?.]*mustache", "").trim());
              String _pyName_1 = dsDaoEntity.getPyName();
              File formatScriptFile = GetTaskDirectory.getAnalysisPath(pyTaskName, 
                IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_pyName_1, "format", "mustache")), "."));
              String _absolutePath_1 = formatScriptFile.getAbsolutePath();
              String _formatScriptText = it.getFormatScriptText();
              FileWriteEntity _fileWriteEntity_1 = new FileWriteEntity(_absolutePath_1, _formatScriptText);
              fileWriteList.add(_fileWriteEntity_1);
              dsDaoEntity.setFormatScriptFilePath(formatScriptFile.getAbsolutePath());
            } else {
              boolean _match_1 = p5.match("/^#![^?.]*thymeleaf[^?.]*$/", it.getFormatScriptText().trim());
              if (_match_1) {
                it.setFormatScriptText(it.getFormatScriptText().replaceFirst("#![^?.]*thymeleaf", "").trim());
                String _pyName_2 = dsDaoEntity.getPyName();
                File formatScriptFile_1 = GetTaskDirectory.getAnalysisPath(pyTaskName, 
                  IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_pyName_2, "format", "html")), "."));
                String _absolutePath_2 = formatScriptFile_1.getAbsolutePath();
                String _formatScriptText_1 = it.getFormatScriptText();
                FileWriteEntity _fileWriteEntity_2 = new FileWriteEntity(_absolutePath_2, _formatScriptText_1);
                fileWriteList.add(_fileWriteEntity_2);
                dsDaoEntity.setFormatScriptFilePath(formatScriptFile_1.getAbsolutePath());
              }
            }
            dsDaoEntity.setUuid(UUID.randomUUID().toString());
            this.taskService.saveTaskResult(dsDaoEntity);
          }
        };
        entity.forEach(_function);
        Integer _taskVersion = taskEntity.getTaskVersion();
        int _plus = ((_taskVersion).intValue() + 1);
        taskEntity.setTaskVersion(Integer.valueOf(_plus));
        final ICallback2<List<FileWriteEntity>> _function_1 = () -> {
          return fileWriteList;
        };
        this.taskService.FileWrite(GetTaskDirectory.getWorkspace(pyTaskName), 
          (taskEntity.getTaskVersion()).intValue(), _function_1);
        this.taskService.update(taskEntity);
        return Response.status(201).build();
      }
    }
    return Response.status(500).build();
  }
  
  @Override
  public Response getTask(final String uuid) {
    try {
      TaskController.LOG.info("获取 {} ID的任务", uuid);
      final TaskDaoEntity entity = this.taskService.getOneTask(uuid);
      String dsId = entity.getDatasourceId();
      String dpId = entity.getDataProcessingId();
      DataSourceDaoEntity dataSourceEntity = this.taskService.getOneDataSourceByUuid(dsId);
      DataProcessingDaoEntity dataProcessingEntity = this.taskService.getOneDataProcessingByUuid(dpId);
      List<TaskResultDaoEntity> taskResultList = this.taskService.getAllByTaskId(entity.getTaskId());
      TaskController.RespTaskEntity respTaskEntity = new TaskController.RespTaskEntity();
      respTaskEntity.taskId = entity.getTaskId();
      respTaskEntity.taskName = entity.getTaskName();
      respTaskEntity.dataSource = dataSourceEntity;
      DataProcessingEntity dping = new DataProcessingEntity();
      String _scriptFilePath = dataProcessingEntity.getScriptFilePath();
      File _file = new File(_scriptFilePath);
      dping.setDataProcessingScript(FileUtils.readFileToString(_file, "UTF-8"));
      dping.setName(dataProcessingEntity.getName());
      respTaskEntity.dataProcessing = dping;
      final ArrayList<TaskDataResultEntity> tdrEntity = new ArrayList<TaskDataResultEntity>();
      final Consumer<TaskResultDaoEntity> _function = (TaskResultDaoEntity it) -> {
        try {
          boolean _isNotBlank = StringUtils.isNotBlank(it.getAnalyzeAndExtractFilePath());
          if (_isNotBlank) {
            TaskDataResultEntity temp = new TaskDataResultEntity();
            String _analyzeAndExtractFilePath = it.getAnalyzeAndExtractFilePath();
            File _file_1 = new File(_analyzeAndExtractFilePath);
            temp.setAnalyzeAndExtractText(FileUtils.readFileToString(_file_1, "UTF-8"));
            boolean _endsWith = it.getFormatScriptFilePath().endsWith(".mustache");
            if (_endsWith) {
              temp.setFormatScriptText("#! mustache");
            } else {
              boolean _endsWith_1 = it.getFormatScriptFilePath().endsWith(".html");
              if (_endsWith_1) {
                temp.setFormatScriptText("#! thymeleaf");
              }
            }
            boolean _isNotBlank_1 = StringUtils.isNotBlank(it.getFormatScriptFilePath());
            if (_isNotBlank_1) {
              String _formatScriptText = temp.getFormatScriptText();
              String _formatScriptFilePath = it.getFormatScriptFilePath();
              File _file_2 = new File(_formatScriptFilePath);
              String _readFileToString = FileUtils.readFileToString(_file_2, "UTF-8");
              temp.setFormatScriptText(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_formatScriptText, _readFileToString)), "\n"));
            }
            temp.setName(it.getName());
            temp.setPyName(it.getPyName());
            tdrEntity.add(temp);
          }
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      taskResultList.forEach(_function);
      respTaskEntity.taskResultList = tdrEntity;
      ResponseEntity<TaskController.RespTaskEntity> r = new ResponseEntity<TaskController.RespTaskEntity>(200).results(respTaskEntity);
      return Response.ok().entity(r).build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public Response putTask(final String uuid, final TaskDaoEntity entity) {
    TaskController.LOG.info("修改 {} ID的任务", uuid);
    TaskDaoEntity taskEntity = this.taskService.getOneTask(uuid);
    String _taskDirectory = taskEntity.getTaskDirectory();
    boolean _exists = new File(_taskDirectory).exists();
    boolean _not = (!_exists);
    if (_not) {
      String pyName = ChineseToPinyin.toPinyin(taskEntity.getTaskName());
      this.jgit.setRepository(GetTaskDirectory.getWorkspace(pyName));
      if ((StringUtils.isNotBlank(taskEntity.getTaskDirectory()) && (!this.jgit.isReprositoryExists()))) {
        this.jgit.init();
      }
      final String baseDir = GetTaskDirectory.getWorkspace(pyName);
      final DataProcessingDaoEntity dpScript = this.taskService.getOneDataProcessingByUuid(taskEntity.getDataProcessingId());
      final List<TaskResultDaoEntity> aps = this.taskService.getAllByTaskId(taskEntity.getTaskId());
      Integer _taskVersion = taskEntity.getTaskVersion();
      int _plus = ((_taskVersion).intValue() + 1);
      taskEntity.setTaskVersion(Integer.valueOf(_plus));
      Integer _taskVersion_1 = taskEntity.getTaskVersion();
      String version = IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList("v", _taskVersion_1)), "");
      final ICallback<AddCommand> _function = (AddCommand it) -> {
        if ((dpScript != null)) {
          String path = FileTools.getSubdirectory(baseDir, dpScript.getScriptFilePath(), "/");
          it.addFilepattern(path.substring(1));
        }
        if (((aps != null) && (((Object[])Conversions.unwrapArray(aps, Object.class)).length > 0))) {
          final Consumer<TaskResultDaoEntity> _function_1 = (TaskResultDaoEntity ait) -> {
            String path_1 = FileTools.getSubdirectory(baseDir, ait.getAnalyzeAndExtractFilePath(), "/");
            it.addFilepattern(path_1.substring(1));
            path_1 = FileTools.getSubdirectory(baseDir, ait.getFormatScriptFilePath(), "/");
            it.addFilepattern(path_1.substring(1));
          };
          aps.forEach(_function_1);
        }
      };
      this.jgit.addAndCommit(version, _function);
      this.taskService.update(taskEntity);
    }
    return Response.status(201).build();
  }
  
  @Override
  public Response deleteTask(final String uuid) {
    TaskController.LOG.info("删除任务:{}", uuid);
    TaskDaoEntity oldTask = this.taskService.getOneTask(uuid);
    String _trim = oldTask.getTaskDirectory().trim();
    File dir = new File(_trim);
    TaskController.LOG.info("要删除的目录为: {}", dir.getAbsolutePath());
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(oldTask.getTaskDirectory());
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      try {
        boolean _deleteQuietly = FileUtils.deleteQuietly(dir);
        if (_deleteQuietly) {
          TaskController.LOG.info("删除任务 {} 目录成功", dir.getAbsolutePath());
          this.taskService.deleteTaskResultByTaskId(oldTask.getTaskId());
          this.taskService.deleteTaskDataProcessing(oldTask.getDataProcessingId());
          this.taskService.deleteDataSource(oldTask.getDatasourceId());
          int _deleteOneTask = this.taskService.deleteOneTask(oldTask.getTaskId());
          boolean _greaterThan = (_deleteOneTask > 0);
          if (_greaterThan) {
            TaskController.LOG.info("删除任务 {} 成功", uuid);
            return Response.status(200).build();
          } else {
            TaskController.LOG.info("删除任务 {} 失败", uuid);
            return Response.status(402).build();
          }
        } else {
          TaskController.LOG.info("删除任务 {} 目录失败", dir.getAbsolutePath());
          return Response.status(402).build();
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception ex = (Exception)_t;
          ex.printStackTrace();
          return Response.status(500).build();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    return null;
  }
  
  @Deprecated
  @Override
  public Response postTask(final TaskDaoEntity entity) {
    return this.OK;
  }
  
  @Override
  public Response runTask(final String uuid) {
    try {
      final Vector<InputStream> isv = new Vector<InputStream>();
      String groovyScript = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(TaomuboxConfigure.basePath, "script")), File.separator);
      boolean _exists = new File(groovyScript).exists();
      if (_exists) {
        final ICallback<File> _function = (File it) -> {
          try {
            if ((it.isFile() && it.getName().endsWith(".groovy"))) {
              FileInputStream _fileInputStream = new FileInputStream(it);
              isv.add(_fileInputStream);
            }
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        };
        FileTools.scannerFile(groovyScript, _function);
      }
      String coding = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("import cool.taomu.box.job.server.script.runtime.GTask", "public void Task(@DelegatesTo(GTask) Closure<GTask> closure){", "closure.delegate = gtask", "closure()", "}\n\n")), "\n");
      byte[] _bytes = coding.getBytes();
      ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
      isv.add(_byteArrayInputStream);
      TaskDaoEntity entity = this.taskService.getOneTask(uuid);
      String dpId = entity.getDataProcessingId();
      DataProcessingDaoEntity dpEntity = this.taskService.getOneDataProcessingByUuid(dpId);
      DataSourceDaoEntity dsEntity = this.taskService.getOneDataSourceByUuid(entity.getDatasourceId());
      String _scriptFilePath = dpEntity.getScriptFilePath();
      File _file = new File(_scriptFilePath);
      String scriptFile = FileUtils.readFileToString(_file, "UTF-8");
      byte[] _bytes_1 = StringUtils.defaultString(scriptFile, "").getBytes();
      ByteArrayInputStream _byteArrayInputStream_1 = new ByteArrayInputStream(_bytes_1);
      isv.add(_byteArrayInputStream_1);
      String _taskDirectory = entity.getTaskDirectory();
      DataSource _dataSource = new DataSource(dsEntity, _taskDirectory, this.jgit);
      this.task.setDs(_dataSource);
      this.task.setWorkspace(entity.getTaskDirectory());
      HashMap<String, String> _hashMap = new HashMap<String, String>();
      this.task.setEnv(_hashMap);
      Integer _taskVersion = entity.getTaskVersion();
      int _plus = ((_taskVersion).intValue() + 1);
      this.task.setVersion(_plus);
      entity.setTaskVersion(Integer.valueOf(this.task.getVersion()));
      this.task.setPyName(ChineseToPinyin.toPinyin(entity.getTaskName()));
      this.task.getEnv().put("workspace", GetTaskDirectory.getWorkspace(this.task.getPyName()));
      this.task.getEnv().put("bin", GetTaskDirectory.getBinDirectory());
      Pair<String, GTask> _mappedTo = Pair.<String, GTask>of("gtask", this.task);
      Pair<String, Logger> _mappedTo_1 = Pair.<String, Logger>of("log", TaskController.LOG);
      GroovyDsl.dsl(isv, Collections.<String, Object>unmodifiableMap(CollectionLiterals.<String, Object>newHashMap(_mappedTo, _mappedTo_1)));
      this.taskService.update(entity);
      String _pyName = this.task.getPyName();
      File dataResultFile = GetTaskDirectory.getDataresult(this.task.getPyName(), IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_pyName, "result", "txt")), "."));
      this.trunService.taskResultProcessing(dataResultFile, entity);
      return this.OK;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public Response exitTask(final String uuid) {
    TaskDaoEntity entity = this.taskService.getOneTask(uuid);
    TaskController.LOG.info("结束任务:{}", entity.getTaskName());
    entity.setStatus(TaskDaoEntity.TaskStatus.DONE.ordinal());
    this.taskService.update(entity);
    return Response.ok().build();
  }
  
  @Override
  public Response getTaskType() {
    TaskController.LOG.info("获取任务类型");
    return Response.ok(this.taskService.getTaskTypeList()).build();
  }
  
  @Override
  public Response getTaskResult(final String uuid) {
    TaskDaoEntity entity = this.taskService.getOneTask(uuid);
    TaskController.LOG.info("获取任务{}结果", entity.getTaskName());
    List<TaskResultDaoEntity> all = this.taskService.getAllByTaskId(entity.getTaskId());
    final HtmlTemplateEntity results = new HtmlTemplateEntity();
    ArrayList<HtmlTemplateEntity.DataEntity> _arrayList = new ArrayList<HtmlTemplateEntity.DataEntity>();
    results.setData(_arrayList);
    final Consumer<TaskResultDaoEntity> _function = (TaskResultDaoEntity it) -> {
      try {
        boolean _isNotBlank = StringUtils.isNotBlank(it.getHtmlResultPath());
        if (_isNotBlank) {
          String _htmlResultPath = it.getHtmlResultPath();
          File _file = new File(_htmlResultPath);
          String text = FileUtils.readFileToString(_file, "UTF-8");
          Perl5Util p5 = new Perl5Util();
          boolean _match = p5.match("/^#![^?.]*markdown[^?.]*$/", text.trim());
          if (_match) {
            File file = File.createTempFile("", ".md");
            text = text.replaceFirst("#![^?.]*markdown", "").trim();
            FileUtils.writeStringToFile(file, text, "UTF-8");
            HtmlTemplateEntity.DataEntity data = new HtmlTemplateEntity.DataEntity();
            data.setResultText(MarkdownUtils.getHtml(file));
            data.setName(it.getName());
            data.setPyname(it.getPyName());
            results.getData().add(data);
            file.delete();
          } else {
            HtmlTemplateEntity.DataEntity data_1 = new HtmlTemplateEntity.DataEntity();
            data_1.setResultText(text);
            data_1.setName(it.getName());
            data_1.setPyname(it.getPyName());
            results.getData().add(data_1);
          }
        }
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    };
    all.forEach(_function);
    TaskController.LOG.info("获取任务{}结果 {} 条", entity.getTaskName(), Integer.valueOf(results.getData().size()));
    int _status = entity.getStatus();
    int _ordinal = TaskDaoEntity.TaskStatus.SUCCESS.ordinal();
    boolean _equals = (_status == _ordinal);
    if (_equals) {
      int _status_1 = entity.getStatus();
      List<HtmlTemplateEntity.DataEntity> _data = results.getData();
      TaskResultEntity<List<HtmlTemplateEntity.DataEntity>> taskResultEntity = new TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>(_status_1, _data).taskId(entity.getTaskId());
      ResponseEntity<TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>> res = new ResponseEntity<TaskResultEntity<List<HtmlTemplateEntity.DataEntity>>>(200).results(taskResultEntity);
      return Response.ok(res.msg("获取任务结果")).build();
    }
    ResponseEntity<Object> res_1 = new ResponseEntity<Object>(Response.Status.NOT_FOUND);
    return Response.status(Response.Status.NOT_FOUND).entity(res_1).build();
  }
  
  @Override
  public Response getTaskList() {
    List<TaskDaoEntity> entitys = this.taskService.getTaskAll();
    final List<TaskDaoEntity> _converted_entitys = (List<TaskDaoEntity>)entitys;
    TaskController.LOG.info("获取任务列表:{}", Integer.valueOf(((Object[])Conversions.unwrapArray(_converted_entitys, Object.class)).length));
    return Response.ok(entitys).build();
  }
  
  @Override
  public Response getTaskStatus(final String uuid) {
    TaskDaoEntity entity = this.taskService.getOneTask(uuid);
    int _status = entity.getStatus();
    int _ordinal = TaskDaoEntity.TaskStatus.SUCCESS.ordinal();
    boolean _equals = (_status == _ordinal);
    if (_equals) {
      ResponseEntity<Object> res = new ResponseEntity<Object>(201);
      return Response.status(201).entity(res).build();
    } else {
      int _status_1 = entity.getStatus();
      int _ordinal_1 = TaskDaoEntity.TaskStatus.IN_PROGRESS.ordinal();
      boolean _equals_1 = (_status_1 == _ordinal_1);
      if (_equals_1) {
        ResponseEntity<Object> res_1 = new ResponseEntity<Object>(100);
        return Response.status(100).entity(res_1).build();
      } else {
        int _status_2 = entity.getStatus();
        int _ordinal_2 = TaskDaoEntity.TaskStatus.FAIL.ordinal();
        boolean _equals_2 = (_status_2 == _ordinal_2);
        if (_equals_2) {
          ResponseEntity<Object> res_2 = new ResponseEntity<Object>(500);
          return Response.status(500).entity(res_2).build();
        } else {
          int _status_3 = entity.getStatus();
          int _ordinal_3 = TaskDaoEntity.TaskStatus.WAIT.ordinal();
          boolean _equals_3 = (_status_3 == _ordinal_3);
          if (_equals_3) {
            ResponseEntity<Object> res_3 = new ResponseEntity<Object>(202);
            return Response.status(202).entity(res_3).build();
          }
        }
      }
    }
    ResponseEntity<Object> res_4 = new ResponseEntity<Object>(100);
    return Response.status(100).entity(res_4).build();
  }
  
  @Override
  public Response getTaskStatusAll() {
    List<TaskDaoEntity> entity = this.taskService.getTaskAll();
    final ArrayList<ResponseEntity> list = new ArrayList<ResponseEntity>();
    final Consumer<TaskDaoEntity> _function = (TaskDaoEntity it) -> {
      int _status = it.getStatus();
      int _ordinal = TaskDaoEntity.TaskStatus.SUCCESS.ordinal();
      boolean _equals = (_status == _ordinal);
      if (_equals) {
        ResponseEntity<Object> res = new ResponseEntity<Object>(201);
        list.add(res);
      } else {
        int _status_1 = it.getStatus();
        int _ordinal_1 = TaskDaoEntity.TaskStatus.IN_PROGRESS.ordinal();
        boolean _equals_1 = (_status_1 == _ordinal_1);
        if (_equals_1) {
          ResponseEntity<Object> res_1 = new ResponseEntity<Object>(100);
          list.add(res_1);
        } else {
          int _status_2 = it.getStatus();
          int _ordinal_2 = TaskDaoEntity.TaskStatus.FAIL.ordinal();
          boolean _equals_2 = (_status_2 == _ordinal_2);
          if (_equals_2) {
            ResponseEntity<Object> res_2 = new ResponseEntity<Object>(500);
            list.add(res_2);
          } else {
            int _status_3 = it.getStatus();
            int _ordinal_3 = TaskDaoEntity.TaskStatus.WAIT.ordinal();
            boolean _equals_3 = (_status_3 == _ordinal_3);
            if (_equals_3) {
              ResponseEntity<Object> res_3 = new ResponseEntity<Object>(202);
              list.add(res_3);
            }
          }
        }
      }
    };
    entity.forEach(_function);
    return Response.status(200).entity(list).build();
  }
}
