package cool.taomu.box.job.server.dao;

import cool.taomu.box.job.server.dao.entity.SecurityDaoEntity;
import cool.taomu.box.job.server.dao.provider.SecurityDaoProvider;
import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
@SuppressWarnings("all")
public interface SecurityDao {
  @Select("select * from taomubox_security where uuid in (select sid from taomubox_security_user where uid = #{userId})")
  List<SecurityDaoEntity> getByUserId(@Param("userId") final String userId);
  
  @Select("select * from taomubox_security where uuid =  #{uuid}")
  SecurityDaoEntity getByUuId(@Param("uuid") final String uuid);
  
  @Select("select * from taomubox_security where role =  #{role}")
  SecurityDaoEntity getByRole(@Param("role") final String role);
  
  @Select("select * from taomubox_security where uuid in (#{uuids})")
  List<SecurityDaoEntity> getByUuids(@Param("uuids") final String uuids);
  
  @InsertProvider(type = SecurityDaoProvider.class, method = "insert")
  int saveSecurity(final SecurityDaoEntity t);
  
  @Delete("delete from taomubox_security where uuid = #{uuid}")
  int deleteSecurity(@Param("uuid") final String uuid);
  
  @Delete("delete from taomubox_security_user where uid = #{uid}")
  int deleteSecurityUserByUid(@Param("uid") final String uid);
  
  @Delete("delete from taomubox_security_user where sid = #{sid}")
  int deleteSecurityUserBySid(@Param("sid") final String sid);
  
  @Insert("insert into taomubox_security_user(uid,sid) values(#{uid},#{sid})")
  int saveSecurityUser(@Param("uid") final String uid, @Param("sid") final String sid);
}
