/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.server.script.runtime;

import cool.taomu.box.git.JGitTools;
import cool.taomu.box.job.server.script.runtime.DataSource;
import cool.taomu.box.job.server.utils.CsvUtils;
import cool.taomu.box.job.server.utils.GetTaskDirectory;
import cool.taomu.box.job.server.utils.ShellExecute;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
public class GTask {
    private static final Logger LOG = LoggerFactory.getLogger(GTask.class);
    private DataSource ds;
    private String workspace;
    private String pyName;
    private int version;
    private Map<String, String> env;
    private File shellFile;

    public void datasource(@DelegatesTo(value=DataSource.class) Closure<DataSource> closure) {
        closure.setDelegate((Object)this.ds);
        closure.call();
    }

    public void analyze(String name, Closure<Analyze> closure) {
        try {
            if (this.shellFile != null) {
                List content = FileUtils.readLines((File)this.shellFile, (String)"UTF-8");
                File file = GetTaskDirectory.getDataresult(this.pyName, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.pyName, name, "result", "csv"})), (CharSequence)"."));
                Analyze anlyzeObj = new Analyze();
                anlyzeObj.content = content;
                String _absolutePath = file.getAbsolutePath();
                CsvUtils _csvUtils = new CsvUtils(_absolutePath);
                anlyzeObj.csv = _csvUtils;
                closure.setDelegate((Object)anlyzeObj);
                closure.call();
                anlyzeObj.csv.write();
                JGitTools _jgit = this.ds.getJgit();
                _jgit.setRepository(GetTaskDirectory.getWorkspace(this.pyName));
                ICallback _function = it -> {
                    String path = FileTools.getSubdirectory((String)GetTaskDirectory.getWorkspace(this.pyName), (String)file.getAbsolutePath(), (String)"/").substring(1);
                    it.addFilepattern(path);
                };
                this.ds.getJgit().addAndCommit(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{"v", this.version, "csv result"})), (CharSequence)"\n"), _function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public File shell(String content) {
        try {
            File _xblockexpression = null;
            LOG.info(content.trim());
            File file = GetTaskDirectory.getDataresult(this.pyName, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.pyName, "result", "txt"})), (CharSequence)"."));
            String fname = UUID.randomUUID().toString().replace("-", "");
            if (!SystemUtils.IS_OS_WINDOWS) {
                File sh = File.createTempFile(fname, ".sh");
                LOG.info("\u6267\u884c\u811a\u672c\u8def\u5f84:{}", (Object)sh.getAbsolutePath());
                FileUtils.writeStringToFile((File)sh, (String)content.trim(), (String)"UTF-8");
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8");
                ShellExecute.ShellCallback _function = it -> LOG.info("chmod +x : {}", (Object)it);
                ShellExecute.start("Linux", _function, this.env, "chmod", "+x", sh.getAbsolutePath());
                ShellExecute.ShellCallback _function_1 = it -> {
                    try {
                        FileUtils.writeLines((File)file, (String)"UTF-8", Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{it})), (boolean)true);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ShellExecute.start("Linux", _function_1, this.env, "/bin/bash", "-c", sh.getAbsolutePath());
                sh.delete();
            } else {
                File sh_1 = File.createTempFile(fname, ".bat");
                FileUtils.writeStringToFile((File)sh_1, (String)content.trim(), (String)"UTF-8");
                ShellExecute.ShellCallback _function_2 = it -> {
                    try {
                        FileUtils.writeStringToFile((File)file, (String)it, (String)"UTF-8");
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ShellExecute.start("Windows", _function_2, this.env, sh_1.getAbsolutePath());
            }
            JGitTools _jgit = this.ds.getJgit();
            _jgit.setRepository(GetTaskDirectory.getWorkspace(this.pyName));
            ICallback _function_3 = it -> {
                String path = FileTools.getSubdirectory((String)GetTaskDirectory.getWorkspace(this.pyName), (String)file.getAbsolutePath(), (String)"/").substring(1);
                it.addFilepattern(path);
            };
            this.ds.getJgit().addAndCommit(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{"v", this.version, "run result"})), (CharSequence)"\n"), _function_3);
            _xblockexpression = this.shellFile = file;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Pure
    public DataSource getDs() {
        return this.ds;
    }

    public void setDs(DataSource ds) {
        this.ds = ds;
    }

    @Pure
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    @Pure
    public String getPyName() {
        return this.pyName;
    }

    public void setPyName(String pyName) {
        this.pyName = pyName;
    }

    @Pure
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Pure
    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    @Pure
    public File getShellFile() {
        return this.shellFile;
    }

    public void setShellFile(File shellFile) {
        this.shellFile = shellFile;
    }

    @Accessors
    public static class Analyze {
        private CsvUtils csv;
        private List<String> content;

        public void csv(String ... args) {
            this.csv.append(args);
        }

        public void analyzer(Closure closure) {
            closure.call(this.content);
        }

        @Pure
        public CsvUtils getCsv() {
            return this.csv;
        }

        public void setCsv(CsvUtils csv) {
            this.csv = csv;
        }

        @Pure
        public List<String> getContent() {
            return this.content;
        }

        public void setContent(List<String> content) {
            this.content = content;
        }
    }
}

